package com.thebeastshop.scm.es;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import pers.richard.ormybatis.domain.core.AbstractDomain;

public class PsAttributeVO extends AbstractDomain {

	private Long id;
	private String groupName;
	private Integer combined;
	private String attrName;
	private List<PsAttributeValueVO> valueList = new ArrayList<>();
	
	public PsAttributeVO(){}
	
	public PsAttributeVO(Map attributeMap){
		this.id = MapUtils.getLong(attributeMap, "id");
		this.groupName  = MapUtils.getString(attributeMap, "groupName");
		this.combined  = MapUtils.getInteger(attributeMap, "combined");
		this.attrName  = MapUtils.getString(attributeMap, "attrName");
		List<Map> valueMapList = (List<Map>) attributeMap.get("valueList");
		for (Map valueMap : valueMapList) {
			PsAttributeValueVO attributeValue = new PsAttributeValueVO(valueMap);
			valueList.add(attributeValue);
		}
//		String valueTexts = MapUtils.getString(attributeMap, "valueTexts");
//		if (StringUtils.isNotBlank(valueTexts)) {
//			this.valueTextList = Arrays.asList(StringUtils.split(valueTexts, ","));
//		}
	}

	@Override
	public Map<String, Object> toMap() {
		Map map = super.toMap();
		List<Map> valueListMap = new ArrayList<>();
		for (PsAttributeValueVO attributeValueVO : valueList) {
			Map valueMap = attributeValueVO.toMap();
			valueListMap.add(valueMap);
		}
		map.put("valueList", valueListMap);
		return map;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public List<PsAttributeValueVO> getValueList() {
		return valueList;
	}

	public void setValueList(List<PsAttributeValueVO> valueList) {
		this.valueList = valueList;
	}

	public String getGroupName() {
		return groupName;
	}
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}
	public Integer getCombined() {
		return combined;
	}
	public void setCombined(Integer combined) {
		this.combined = combined;
	}
	public String getAttrName() {
		return attrName;
	}
	public void setAttrName(String attrName) {
		this.attrName = attrName;
	}
}
