package com.thebeastshop.scm.es;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.po.Campaign;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-07-15
 */
public class PsCampaignVO extends PsUpdateVO {

    private Long id;

    private String name;

    private String title;

    private Integer state;

    /**
     * 商品范围。1=单品；2=多品；3=全场
     */
    private Integer productScopeId;

    /**
     * 折扣类型。1=打折；2=满减；3=买赠；4=加价购
     */
    private Integer discountTypeId;

    /**
     * 是否海淘
     */
    private Integer crossBorderFlag;

    private String discountTypeName;

    private List<Integer> accessWayIds;

    private List<Integer> memberLevels;

    private List<Integer> buIds; //活动适用BU。1.TBH  2.HOME  3.MISS BEAST  4.LITTLE B  5.BlingBling 6.Naked Beast 7.Buto 10.Naked Beast (UW)Bu


    private Date startTime;
    private Date expireTime;
    private Integer advance;                                    // 是否预告
    private Date advanceStartTime;                              // 预告开始时间
    private Date advanceEndTime;                                // 预告结束时间
    private String advancePriceTitle;                           // 预告价格文案
    private String code;                                        // 活动编码
    private Integer active;                                     // 活动是否有效 1.有效 0.无效
    private List<String> excludeStores;


    private List<Long> excludeProductIds;
    private List<String> excludeSukCodes;
    private String memberType;                        //01新人专享活动 00普通折扣活动


    public PsCampaignVO() {}

    public PsCampaignVO(Campaign campaign) {
        id = campaign.getId().longValue();
        code = campaign.getCode();
        name = campaign.getName();
        title = campaign.getTitle();
        state = campaign.getState();
        productScopeId = campaign.getProductScope();
        discountTypeId = campaign.getDiscountType();
        DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.valueOf(discountTypeId);
        if (discountTypeEnum != null) {
            discountTypeName = discountTypeEnum.getName();
        }
        crossBorderFlag = campaign.getCrossBorderFlag();
        accessWayIds = splitIds(campaign.getAccessWay());
        memberLevels = splitIds(campaign.getMemberLevel());
        buIds = splitIds(campaign.getBu());
        startTime = campaign.getStartTime();
        expireTime = campaign.getExpireTime();
        advance = campaign.getIsAdvance();
        advanceStartTime = campaign.getAdvanceStartTime();
        advanceEndTime = campaign.getAdvanceEndTime();
        advancePriceTitle = campaign.getAdvancePriceTitle();
        active = campaign.getActive();
        String excludeStoresDesc = campaign.getExcludeStores();
        List<String> excludeStores = Lists.newArrayList();
        if (StringUtils.isNotEmpty(excludeStoresDesc)) {
            excludeStores = Lists.newArrayList(excludeStoresDesc.split(","));
        }
        this.excludeStores = excludeStores;
        this.memberType = campaign.getMemberType();
    }

    /**
     * 转换Campaign集合为VO集合
     * @param domains
     * @return
     */
    public static List<PsCampaignVO> transfer(List<Campaign> domains){
        List<PsCampaignVO> result = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(domains)) {
            PsCampaignVO vo;
            for (Campaign domain : domains) {
                vo = new PsCampaignVO(domain);
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashedMap();
        map.put("id", id);
        map.put("code", code);
        map.put("name", name);
        map.put("title", title);
        map.put("state", state);
        map.put("productScopeId", productScopeId);
        map.put("discountTypeId", discountTypeId);
        if (discountTypeName != null) {
            map.put("discountTypeName", discountTypeName);
        }
        map.put("crossBorderFlag", crossBorderFlag);
        map.put("accessWayIds", accessWayIds);
        map.put("memberLevels", memberLevels);
        map.put("buIds", buIds);
        map.put("startTime", startTime);
        map.put("expireTime", expireTime);
        map.put("advance", advance);
        map.put("advanceStartTime", advanceStartTime);
        map.put("advanceEndTime", advanceEndTime);
        map.put("advancePriceTitle", advancePriceTitle);
        map.put("active", active);
        map.put("excludeStores", excludeStores);
        map.put("excludeProductIds", excludeProductIds);
        map.put("excludeSukCodes", excludeSukCodes);
        map.put("memberType",memberType);
        return map;
    }

    private List<Integer> splitIds(String str) {
        List<Integer> ids = new ArrayList<>();
        if (StringUtils.isNoneBlank(str)) {
            String[] idArr = str.split(",");
            for (String id : idArr) {
                if (StringUtils.isNoneBlank(id)) {
                    try {
                        ids.add(Integer.valueOf(id));
                    } catch (Exception ex) {}
                }
            }
        }
        return ids;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getProductScopeId() {
        return productScopeId;
    }

    public void setProductScopeId(Integer productScopeId) {
        this.productScopeId = productScopeId;
    }

    public Integer getDiscountTypeId() {
        return discountTypeId;
    }

    public void setDiscountTypeId(Integer discountTypeId) {
        this.discountTypeId = discountTypeId;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public String getDiscountTypeName() {
        return discountTypeName;
    }

    public void setDiscountTypeName(String discountTypeName) {
        this.discountTypeName = discountTypeName;
    }

    public List<Integer> getAccessWayIds() {
        return accessWayIds;
    }

    public void setAccessWayIds(List<Integer> accessWayIds) {
        this.accessWayIds = accessWayIds;
    }

    public List<Integer> getMemberLevels() {
        return memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getAdvance() {
        return advance;
    }

    public void setAdvance(Integer advance) {
        this.advance = advance;
    }

    public Date getAdvanceStartTime() {
        return advanceStartTime;
    }

    public void setAdvanceStartTime(Date advanceStartTime) {
        this.advanceStartTime = advanceStartTime;
    }

    public Date getAdvanceEndTime() {
        return advanceEndTime;
    }

    public void setAdvanceEndTime(Date advanceEndTime) {
        this.advanceEndTime = advanceEndTime;
    }



    public String getAdvancePriceTitle() {
        return advancePriceTitle;
    }

    public void setAdvancePriceTitle(String advancePriceTitle) {
        this.advancePriceTitle = advancePriceTitle;
    }

    public Integer getActive() {
        return active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<Long> getExcludeProductIds() {
        return excludeProductIds;
    }

    public void setExcludeProductIds(List<Long> excludeProductIds) {
        this.excludeProductIds = excludeProductIds;
    }

    public List<String> getExcludeSukCodes() {
        return excludeSukCodes;
    }

    public void setExcludeSukCodes(List<String> excludeSukCodes) {
        this.excludeSukCodes = excludeSukCodes;
    }

    public List<String> getExcludeStores() {
        return excludeStores;
    }

    public void setExcludeStores(List<String> excludeStores) {
        this.excludeStores = excludeStores;
    }

    public List<Integer> getBuIds() {
        return buIds;
    }

    public void setBuIds(List<Integer> buIds) {
        this.buIds = buIds;
    }


    public String getMemberType() {
        return memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }
}
