/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.es;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.es.PsAttributeVO;
import com.thebeastshop.scm.es.PsBaseSkuVO;
import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.es.PsChnProdSaleSku;
import com.thebeastshop.scm.es.PsChnProdTimeCodeInfo;
import com.thebeastshop.scm.es.PsCommissionVO;
import com.thebeastshop.scm.es.PsDeliveryVO;
import com.thebeastshop.scm.es.PsSkuAttributeVO;
import com.thebeastshop.scm.es.PsSpvVO;
import com.thebeastshop.scm.es.PsUpdateVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class PsProductVO
extends PsUpdateVO {
    private String id;
    private String code;
    private Integer combined;
    private BigDecimal listPrice;
    private BigDecimal originalPrice;
    private String listPriceSkuCode;
    private Integer listPriceSpvId;
    private LinkedHashMap<String, Map> listPriceList;
    private Integer allowVipDiscount;
    private Integer allowBdDiscount;
    private Integer allowCampaign;
    private Integer allowCoupon;
    private Integer allowNoteCard;
    private Integer prepareDays;
    private Integer selectDeliveryDays;
    private String picList;
    private String picDetail;
    private String picThumb;
    private String picDetailMul;
    private Integer expressType;
    private String name;
    private String nameCn;
    private String skuCategoryDesc;
    private Long categoryId;
    private String categoryCode;
    private List<PsCampaignVO> campaignList = new ArrayList<PsCampaignVO>();
    private String description;
    private Date saleStartDate;
    private Integer crossBorderFlag;
    private Integer isJit;
    private Integer canCustomize;
    private Integer detailBigimgSeq;
    private String detailBigimgUrl;
    private Map<String, String> canSaleSkuMap;
    private Map<String, String> canSeeSkuMap;
    private Integer isDiscount;
    private String video;
    private String videoCover;
    private Integer displayInProdDetail;
    private Integer displayInCombinedArea;
    private List<String> skuCodes = new ArrayList<String>();
    private List<String> smallIconList = new ArrayList<String>();
    private List<String> largeIconList = new ArrayList<String>();
    private List<String> onShelfChnCodes = new ArrayList<String>();
    private List<String> onShelfChnCodesOnLine = new ArrayList<String>();
    private List<Map> frontCategories = new ArrayList<Map>();
    private List<Map> secondFrontCategories = new ArrayList<Map>();
    private List<Map> stocks = new ArrayList<Map>();
    private List<Map> stocksOnLine = new ArrayList<Map>();
    private List<PsDeliveryVO> selfDeliveries = new ArrayList<PsDeliveryVO>();
    private List<PsChnProdSaleSku> chnCanSaleSKu = new ArrayList<PsChnProdSaleSku>();
    private List<PsChnProdSaleSku> chnCanSeeSKu = new ArrayList<PsChnProdSaleSku>();
    private List<PsChnProdSaleSku> chnCanSaleSKuOnLine = new ArrayList<PsChnProdSaleSku>();
    private List<PsChnProdSaleSku> chnCanSeeSKuOnLine = new ArrayList<PsChnProdSaleSku>();
    private List<Map> brandList = new ArrayList<Map>();
    private List<PsChnProdTimeCodeInfo> channelProdInfo = new ArrayList<PsChnProdTimeCodeInfo>();
    private List<Map> labels = new ArrayList<Map>();
    private List<PsAttributeVO> attributeList = new ArrayList<PsAttributeVO>();
    private List<PsSpvVO> spvList = new ArrayList<PsSpvVO>();
    private List<PsBaseSkuVO> baseSkuList = new ArrayList<PsBaseSkuVO>();
    private List<Long> backCategoryIds = new ArrayList<Long>();
    private String primaryUpdateTime;
    private Long primaryUpdateLong;
    private List<PsSkuAttributeVO> skuAttributeList;
    private Integer orderQuantity;
    private Integer favoriteQuantity;
    private List<String> barcodes = new ArrayList<String>();
    private List<String> bu = new ArrayList<String>();
    private String newBu;
    private Integer newBuId;
    private Map brand;
    private Integer brandId;
    private Integer virtualType;
    private Date BeastCourserReserveStartTime;
    private Date BeastCourserSessionStartTime;
    private Integer beastCourseStatus;
    private Integer salesPoint;
    private Integer integratedPoint;
    private List<Map> activityPage = new ArrayList<Map>();
    private String giftRecommendImg;
    private String giftRecommendReason;
    private Integer sellOnLine;
    private List<PsCommissionVO> psCommissionList = new ArrayList<PsCommissionVO>();
    private Integer commissionFlag;
    private String listDisplayVideo;
    private BigDecimal returnFundProportion;
    private BigDecimal useFundProportion;
    private Integer customPrintTemplate;
    private Integer isVipDiscountWhiteProd;
    private Integer hasDeliveryDate;
    private String attrName1;
    private String attrName2;
    private String attrName3;
    public static String[] onLineChannelCode = new String[]{"CHN2018", "CHN2049", "CHN2077", "CHN2078", "CHN2145", "CHN2146"};

    public void initializeProduct() {
        this.attributeList = null;
        this.spvList = null;
        this.chnCanSaleSKu = null;
        this.chnCanSeeSKu = null;
        this.chnCanSaleSKuOnLine = null;
        this.chnCanSeeSKuOnLine = null;
        this.onShelfChnCodes = null;
        this.brandList = null;
        this.largeIconList = null;
        this.smallIconList = null;
        this.campaignList = null;
    }

    public static List<PsSpvVO> getAvaiableSpvs(String chnCode, PsProductVO psProductVO) {
        ArrayList<PsSpvVO> list = new ArrayList<PsSpvVO>();
        Map<String, String> canSaleSkuMap = PsProductVO.getCanSaleSkuMap(chnCode, psProductVO);
        Map<String, String> canSeeSkuMap = PsProductVO.getCanSeeSkuMap(chnCode, psProductVO);
        List<PsSpvVO> spvVOs = psProductVO.getSpvList();
        if (CollectionUtils.isEmpty(spvVOs)) {
            return Lists.newArrayList();
        }
        for (PsSpvVO spvVO : spvVOs) {
            if (!PsSpvVO.isAvaible(chnCode, true, canSaleSkuMap, canSeeSkuMap, spvVO)) continue;
            list.add(spvVO);
        }
        return list;
    }

    public static List<Integer> getAvaiableSpvIds(String chnCode, PsProductVO psProductVO) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<PsSpvVO> spvVOs = PsProductVO.getAvaiableSpvs(chnCode, psProductVO);
        for (PsSpvVO psSpvVO : spvVOs) {
            ids.add(psSpvVO.getSpvId());
        }
        return ids;
    }

    public static Map<String, String> getCanSeeSkuMap(String chnCode, PsProductVO psProductVO) {
        if (psProductVO.canSeeSkuMap != null) {
            return psProductVO.canSeeSkuMap;
        }
        HashedMap canSeeSkuMap = new HashedMap();
        List<PsChnProdSaleSku> canSeeSkuList = psProductVO.getChnCanSeeSKu();
        if (CollectionUtils.isEmpty(canSeeSkuList)) {
            return canSeeSkuMap;
        }
        PsChnProdSaleSku canSeeSku = null;
        for (PsChnProdSaleSku chnProdSaleSkuVO : canSeeSkuList) {
            if (!StringUtils.equals((CharSequence)chnProdSaleSkuVO.getChnCode(), (CharSequence)chnCode)) continue;
            canSeeSku = chnProdSaleSkuVO;
            break;
        }
        if (canSeeSku != null) {
            for (String skuCode : canSeeSku.getCanSkus()) {
                canSeeSkuMap.put(skuCode, skuCode);
            }
        }
        psProductVO.canSeeSkuMap = canSeeSkuMap;
        return canSeeSkuMap;
    }

    public static Map<String, String> getCanSaleSkuMap(String chnCode, PsProductVO psProductVO) {
        if (psProductVO.canSaleSkuMap != null) {
            return psProductVO.canSaleSkuMap;
        }
        HashedMap canSaleSkuMap = new HashedMap();
        List<PsChnProdSaleSku> canSaleSkuList = psProductVO.getChnCanSaleSKu();
        if (CollectionUtils.isEmpty(canSaleSkuList)) {
            return canSaleSkuMap;
        }
        PsChnProdSaleSku canSaleSku = null;
        for (PsChnProdSaleSku chnProdSaleSkuVO : canSaleSkuList) {
            if (!StringUtils.equals((CharSequence)chnProdSaleSkuVO.getChnCode(), (CharSequence)chnCode)) continue;
            canSaleSku = chnProdSaleSkuVO;
            break;
        }
        if (canSaleSku != null) {
            for (String skuCode : canSaleSku.getCanSkus()) {
                canSaleSkuMap.put(skuCode, skuCode);
            }
        }
        psProductVO.canSaleSkuMap = canSaleSkuMap;
        return canSaleSkuMap;
    }

    public List<String> getPicDetailMuls() {
        if (StringUtils.isBlank((CharSequence)this.picDetailMul)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.picDetailMul.split(","));
    }

    public void addIcon(String smallIcon, String largeIcon) {
        if (this.smallIconList == null) {
            this.smallIconList = Lists.newArrayList();
        }
        if (this.largeIconList == null) {
            this.largeIconList = Lists.newArrayList();
        }
        if (StringUtils.isNotBlank((CharSequence)smallIcon)) {
            this.smallIconList.add(smallIcon);
        }
        if (StringUtils.isNotBlank((CharSequence)largeIcon)) {
            this.largeIconList.add(largeIcon);
        }
    }

    public Integer getExpressType() {
        if (this.expressType == null) {
            return 3;
        }
        return this.expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public Long getCategoryId() {
        if (this.categoryId == null) {
            return 0L;
        }
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryCode() {
        return StringUtils.trimToEmpty((String)this.categoryCode);
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public List<Map> getFrontCategories() {
        return this.frontCategories;
    }

    public void setFrontCategories(List<Map> frontCategories) {
        if (frontCategories == null) {
            return;
        }
        this.frontCategories = frontCategories;
    }

    public List<PsCampaignVO> getCampaignList() {
        return this.campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }

    public List<Map> getStocks() {
        return this.stocks;
    }

    public void setStocks(List<Map> stocks) {
        this.stocks = stocks;
    }

    public List<Map> getStocksOnLine() {
        return this.stocksOnLine;
    }

    public void setStocksOnLine(List<Map> stocksOnLine) {
        this.stocksOnLine = stocksOnLine;
    }

    public void setupStockMap(Map<String, Map> stockMap) {
        ArrayList<Map> stockList = new ArrayList<Map>();
        ArrayList<Map> stockOnLineList = new ArrayList<Map>();
        for (String chnCode : stockMap.keySet()) {
            stockList.add(stockMap.get(chnCode));
            if (!Arrays.asList(onLineChannelCode).contains(chnCode)) continue;
            stockOnLineList.add(stockMap.get(chnCode));
        }
        this.setStocks(stockList);
        this.setStocksOnLine(stockOnLineList);
    }

    public List<String> getSmallIconList() {
        return this.smallIconList;
    }

    public void setSmallIconList(List<String> smallIconList) {
        if (smallIconList == null) {
            return;
        }
        this.smallIconList = smallIconList;
    }

    public List<String> getLargeIconList() {
        return this.largeIconList;
    }

    public void setLargeIconList(List<String> largeIconList) {
        if (largeIconList == null) {
            return;
        }
        this.largeIconList = largeIconList;
    }

    public List<PsDeliveryVO> getSelfDeliveries() {
        return this.selfDeliveries;
    }

    public void setSelfDeliveries(List<PsDeliveryVO> selfDeliveries) {
        if (selfDeliveries == null) {
            return;
        }
        this.selfDeliveries = selfDeliveries;
    }

    public List<PsChnProdSaleSku> getChnCanSaleSKu() {
        return this.chnCanSaleSKu;
    }

    public void setChnCanSaleSKu(List<PsChnProdSaleSku> chnCanSaleSKu) {
        if (chnCanSaleSKu == null) {
            return;
        }
        this.chnCanSaleSKu = chnCanSaleSKu;
    }

    public List<String> getOnShelfChnCodes() {
        return this.onShelfChnCodes;
    }

    public void setOnShelfChnCodes(List<String> onShelfChnCodes) {
        if (onShelfChnCodes == null) {
            return;
        }
        this.onShelfChnCodes = onShelfChnCodes;
    }

    public List<String> getOnShelfChnCodesOnLine() {
        return this.onShelfChnCodesOnLine;
    }

    public void setOnShelfChnCodesOnLine(List<String> onShelfChnCodesOnLine) {
        if (onShelfChnCodesOnLine == null) {
            return;
        }
        this.onShelfChnCodesOnLine = onShelfChnCodesOnLine;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public String getListPriceSkuCode() {
        return this.listPriceSkuCode;
    }

    public void setListPriceSkuCode(String listPriceSkuCode) {
        this.listPriceSkuCode = listPriceSkuCode;
    }

    public Integer getListPriceSpvId() {
        return this.listPriceSpvId;
    }

    public void setListPriceSpvId(Integer listPriceSpvId) {
        this.listPriceSpvId = listPriceSpvId;
    }

    public LinkedHashMap<String, Map> getListPriceMapList() {
        return this.listPriceList;
    }

    public void setListPriceMapList(LinkedHashMap<String, Map> listPriceList) {
        this.listPriceList = listPriceList;
    }

    public List<Map> getListPriceList() {
        ArrayList<Map> list = new ArrayList<Map>();
        if (MapUtils.isNotEmpty(this.listPriceList)) {
            for (String key : this.listPriceList.keySet()) {
                Map map = this.listPriceList.get(key);
                list.add(map);
            }
        }
        return list;
    }

    public Integer getAllowVipDiscount() {
        return this.allowVipDiscount;
    }

    public void setAllowVipDiscount(Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return this.allowNoteCard;
    }

    public void setAllowNoteCard(Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }

    public Integer getPrepareDays() {
        return this.prepareDays;
    }

    public void setPrepareDays(Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return this.selectDeliveryDays;
    }

    public void setSelectDeliveryDays(Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

    public String getPicList() {
        return this.picList == null ? "" : this.picList;
    }

    public void setPicList(String picList) {
        this.picList = picList;
    }

    public String getPicDetail() {
        return this.picDetail == null ? "" : this.picDetail;
    }

    public void setPicDetail(String picDetail) {
        this.picDetail = picDetail;
    }

    public String getPicThumb() {
        return this.picThumb == null ? "" : this.picThumb;
    }

    public void setPicThumb(String picThumb) {
        this.picThumb = picThumb;
    }

    public String getName() {
        return StringUtils.trimToEmpty((String)this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return this.nameCn == null ? "" : this.nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public List<String> getSkuCodes() {
        return this.skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        if (skuCodes == null) {
            return;
        }
        this.skuCodes = skuCodes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSkuCategoryDesc() {
        return this.skuCategoryDesc;
    }

    public void setSkuCategoryDesc(String skuCategoryDesc) {
        this.skuCategoryDesc = skuCategoryDesc;
    }

    public List<PsChnProdSaleSku> getChnCanSeeSKu() {
        return this.chnCanSeeSKu;
    }

    public void setChnCanSeeSKu(List<PsChnProdSaleSku> chnCanSeeSKu) {
        if (chnCanSeeSKu == null) {
            return;
        }
        this.chnCanSeeSKu = chnCanSeeSKu;
    }

    public List<PsChnProdSaleSku> getChnCanSeeSKuOnLine() {
        return this.chnCanSeeSKuOnLine;
    }

    public void setChnCanSeeSKuOnLine(List<PsChnProdSaleSku> chnCanSeeSKuOnLine) {
        if (chnCanSeeSKuOnLine == null) {
            return;
        }
        this.chnCanSeeSKuOnLine = chnCanSeeSKuOnLine;
    }

    public List<PsChnProdSaleSku> getChnCanSaleSKuOnLine() {
        return this.chnCanSaleSKuOnLine;
    }

    public void setChnCanSaleSKuOnLine(List<PsChnProdSaleSku> chnCanSaleSKuOnLine) {
        if (chnCanSaleSKuOnLine == null) {
            return;
        }
        this.chnCanSaleSKuOnLine = chnCanSaleSKuOnLine;
    }

    public Date getSaleStartDate() {
        return this.saleStartDate;
    }

    public void setSaleStartDate(Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public String getPicDetailMul() {
        return StringUtils.trimToEmpty((String)this.picDetailMul);
    }

    public void setPicDetailMul(String picDetailMul) {
        this.picDetailMul = picDetailMul;
    }

    public String getDescription() {
        return StringUtils.trimToEmpty((String)this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Map> getBrandList() {
        return this.brandList;
    }

    public void setBrandList(List<Map> brandList) {
        this.brandList = brandList;
    }

    public List<PsChnProdTimeCodeInfo> getChannelProdInfo() {
        return this.channelProdInfo;
    }

    public void setChannelProdInfo(List<PsChnProdTimeCodeInfo> channelProdInfo) {
        this.channelProdInfo = channelProdInfo;
    }

    public Integer getCrossBorderFlag() {
        return this.crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public List<Map> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Map> labels) {
        this.labels = labels;
    }

    public List<PsAttributeVO> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<PsAttributeVO> attributeList) {
        this.attributeList = attributeList;
    }

    public List<PsSpvVO> getSpvList() {
        return this.spvList;
    }

    public void setSpvList(List<PsSpvVO> spvList) {
        this.spvList = spvList;
    }

    public Integer getCombined() {
        return this.combined;
    }

    public void setCombined(Integer combined) {
        this.combined = combined;
    }

    public String getPrimaryUpdateTime() {
        return this.primaryUpdateTime;
    }

    public void setPrimaryUpdateTime(String primaryUpdateTime) {
        this.primaryUpdateTime = primaryUpdateTime;
    }

    public Long getPrimaryUpdateLong() {
        return this.primaryUpdateLong;
    }

    public void setPrimaryUpdateLong(Long primaryUpdateLong) {
        this.primaryUpdateLong = primaryUpdateLong;
    }

    public Integer getAllowBdDiscount() {
        return this.allowBdDiscount;
    }

    public void setAllowBdDiscount(Integer allowBdDiscount) {
        this.allowBdDiscount = allowBdDiscount;
    }

    public Integer getIsDiscount() {
        return this.isDiscount;
    }

    public void setIsDiscount(Integer isDiscount) {
        this.isDiscount = isDiscount;
    }

    public String getVideo() {
        return this.video;
    }

    public void setVideo(String video) {
        this.video = video;
    }

    public String getVideoCover() {
        return this.videoCover;
    }

    public void setVideoCover(String videoCover) {
        this.videoCover = videoCover;
    }

    public List<PsSkuAttributeVO> getSkuAttributeList() {
        return this.skuAttributeList;
    }

    public void setSkuAttributeList(List<PsSkuAttributeVO> skuAttributeList) {
        this.skuAttributeList = skuAttributeList;
    }

    public List<Long> getBackCategoryIds() {
        return this.backCategoryIds;
    }

    public void setBackCategoryIds(List<Long> backCategoryIds) {
        this.backCategoryIds = backCategoryIds;
    }

    public List<PsBaseSkuVO> getBaseSkuList() {
        return this.baseSkuList;
    }

    public void setBaseSkuList(List<PsBaseSkuVO> baseSkuList) {
        this.baseSkuList = baseSkuList;
    }

    public BigDecimal getOriginalPrice() {
        return this.originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getFavoriteQuantity() {
        return this.favoriteQuantity;
    }

    public void setFavoriteQuantity(Integer favoriteQuantity) {
        this.favoriteQuantity = favoriteQuantity;
    }

    public Integer getOrderQuantity() {
        return this.orderQuantity;
    }

    public void setOrderQuantity(Integer orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

    public List<String> getBarcodes() {
        return this.barcodes;
    }

    public void setBarcodes(List<String> barcodes) {
        this.barcodes = barcodes;
    }

    public Integer getDisplayInProdDetail() {
        return this.displayInProdDetail;
    }

    public void setDisplayInProdDetail(Integer displayInProdDetail) {
        this.displayInProdDetail = displayInProdDetail;
    }

    public Integer getDisplayInCombinedArea() {
        return this.displayInCombinedArea;
    }

    public void setDisplayInCombinedArea(Integer displayInCombinedArea) {
        this.displayInCombinedArea = displayInCombinedArea;
    }

    public Integer getDetailBigimgSeq() {
        return this.detailBigimgSeq;
    }

    public void setDetailBigimgSeq(Integer detailBigimgSeq) {
        this.detailBigimgSeq = detailBigimgSeq;
    }

    public String getDetailBigimgUrl() {
        return this.detailBigimgUrl;
    }

    public void setDetailBigimgUrl(String detailBigimgUrl) {
        this.detailBigimgUrl = detailBigimgUrl;
    }

    public Integer getAllowCampaign() {
        return this.allowCampaign;
    }

    public void setAllowCampaign(Integer allowCampaign) {
        this.allowCampaign = allowCampaign;
    }

    public List<String> getBu() {
        return this.bu;
    }

    public void setBu(List<String> bu) {
        this.bu = bu;
    }

    public Map getBrand() {
        return this.brand;
    }

    public void setBrand(Map brand) {
        this.brand = brand;
    }

    public Integer getBrandId() {
        return this.brandId;
    }

    public void setBrandId(Integer brandId) {
        this.brandId = brandId;
    }

    public Integer getIsJit() {
        return this.isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

    public Integer getVirtualType() {
        return this.virtualType;
    }

    public void setVirtualType(Integer virtualType) {
        this.virtualType = virtualType;
    }

    public Integer getBeastCourseStatus() {
        return this.beastCourseStatus;
    }

    public void setBeastCourseStatus(Integer beastCourseStatus) {
        this.beastCourseStatus = beastCourseStatus;
    }

    public Date getBeastCourserReserveStartTime() {
        return this.BeastCourserReserveStartTime;
    }

    public void setBeastCourserReserveStartTime(Date beastCourserReserveStartTime) {
        this.BeastCourserReserveStartTime = beastCourserReserveStartTime;
    }

    public Date getBeastCourserSessionStartTime() {
        return this.BeastCourserSessionStartTime;
    }

    public void setBeastCourserSessionStartTime(Date beastCourserSessionStartTime) {
        this.BeastCourserSessionStartTime = beastCourserSessionStartTime;
    }

    public Integer getSalesPoint() {
        return this.salesPoint;
    }

    public void setSalesPoint(Integer salesPoint) {
        this.salesPoint = salesPoint;
    }

    public Integer getIntegratedPoint() {
        return this.integratedPoint;
    }

    public void setIntegratedPoint(Integer integratedPoint) {
        this.integratedPoint = integratedPoint;
    }

    public String getNewBu() {
        return this.newBu;
    }

    public void setNewBu(String newBu) {
        this.newBu = newBu;
    }

    public List<Map> getActivityPage() {
        return this.activityPage;
    }

    public void setActivityPage(List<Map> activityPage) {
        this.activityPage = activityPage;
    }

    public String getGiftRecommendImg() {
        return this.giftRecommendImg;
    }

    public void setGiftRecommendImg(String giftRecommendImg) {
        this.giftRecommendImg = giftRecommendImg;
    }

    public String getGiftRecommendReason() {
        return this.giftRecommendReason;
    }

    public void setGiftRecommendReason(String giftRecommendReason) {
        this.giftRecommendReason = giftRecommendReason;
    }

    public Integer getSellOnLine() {
        return this.sellOnLine;
    }

    public void setSellOnLine(Integer sellOnLine) {
        this.sellOnLine = sellOnLine;
    }

    public List<Map> getSecondFrontCategories() {
        return this.secondFrontCategories;
    }

    public void setSecondFrontCategories(List<Map> secondFrontCategories) {
        this.secondFrontCategories = secondFrontCategories;
    }

    public Integer getCommissionFlag() {
        return this.commissionFlag;
    }

    public void setCommissionFlag(Integer commissionFlag) {
        this.commissionFlag = commissionFlag;
    }

    public List<PsCommissionVO> getPsCommissionList() {
        return this.psCommissionList;
    }

    public void setPsCommissionList(List<PsCommissionVO> psCommissionList) {
        this.psCommissionList = psCommissionList;
    }

    public String getListDisplayVideo() {
        return this.listDisplayVideo;
    }

    public void setListDisplayVideo(String listDisplayVideo) {
        this.listDisplayVideo = listDisplayVideo;
    }

    public String getAttrName1() {
        return this.attrName1;
    }

    public void setAttrName1(String attrName1) {
        this.attrName1 = attrName1;
    }

    public String getAttrName2() {
        return this.attrName2;
    }

    public void setAttrName2(String attrName2) {
        this.attrName2 = attrName2;
    }

    public String getAttrName3() {
        return this.attrName3;
    }

    public void setAttrName3(String attrName3) {
        this.attrName3 = attrName3;
    }

    public BigDecimal getUseFundProportion() {
        return this.useFundProportion;
    }

    public void setUseFundProportion(BigDecimal useFundProportion) {
        this.useFundProportion = useFundProportion;
    }

    public BigDecimal getReturnFundProportion() {
        return this.returnFundProportion;
    }

    public void setReturnFundProportion(BigDecimal returnFundProportion) {
        this.returnFundProportion = returnFundProportion;
    }

    public Integer getAllowCoupon() {
        return this.allowCoupon;
    }

    public void setAllowCoupon(Integer allowCoupon) {
        this.allowCoupon = allowCoupon;
    }

    public Integer getCustomPrintTemplate() {
        return this.customPrintTemplate;
    }

    public void setCustomPrintTemplate(Integer customPrintTemplate) {
        this.customPrintTemplate = customPrintTemplate;
    }

    public Integer getIsVipDiscountWhiteProd() {
        return this.isVipDiscountWhiteProd;
    }

    public void setIsVipDiscountWhiteProd(Integer isVipDiscountWhiteProd) {
        this.isVipDiscountWhiteProd = isVipDiscountWhiteProd;
    }

    public Integer getHasDeliveryDate() {
        return this.hasDeliveryDate;
    }

    public void setHasDeliveryDate(Integer hasDeliveryDate) {
        this.hasDeliveryDate = hasDeliveryDate;
    }

    public Integer getNewBuId() {
        return this.newBuId;
    }

    public void setNewBuId(Integer newBuId) {
        this.newBuId = newBuId;
    }

    public Integer getCanCustomize() {
        return this.canCustomize;
    }

    public void setCanCustomize(Integer canCustomize) {
        this.canCustomize = canCustomize;
    }
}

