/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.es;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.es.DiscountTypeEnum;
import com.thebeastshop.scm.es.PsUpdateVO;
import com.thebeastshop.scm.po.Campaign;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class PsCampaignVO
extends PsUpdateVO {
    private Long id;
    private String name;
    private String title;
    private Integer state;
    private Integer productScopeId;
    private Integer discountTypeId;
    private Integer crossBorderFlag;
    private String discountTypeName;
    private List<Integer> accessWayIds;
    private List<Integer> memberLevels;
    private List<Integer> buIds;
    private Date startTime;
    private Date expireTime;
    private Integer advance;
    private Date advanceStartTime;
    private Date advanceEndTime;
    private String code;
    private Integer active;
    private List<String> excludeStores;
    private List<Long> excludeProductIds;
    private List<String> excludeSukCodes;
    private String memberType;

    public PsCampaignVO() {
    }

    public PsCampaignVO(Campaign campaign) {
        this.id = campaign.getId().longValue();
        this.code = campaign.getCode();
        this.name = campaign.getName();
        this.title = campaign.getTitle();
        this.state = campaign.getState();
        this.productScopeId = campaign.getProductScope();
        this.discountTypeId = campaign.getDiscountType();
        DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.valueOf(this.discountTypeId);
        if (discountTypeEnum != null) {
            this.discountTypeName = discountTypeEnum.getName();
        }
        this.crossBorderFlag = campaign.getCrossBorderFlag();
        this.accessWayIds = this.splitIds(campaign.getAccessWay());
        this.memberLevels = this.splitIds(campaign.getMemberLevel());
        this.buIds = this.splitIds(campaign.getBu());
        this.startTime = campaign.getStartTime();
        this.expireTime = campaign.getExpireTime();
        this.advance = campaign.getIsAdvance();
        this.advanceStartTime = campaign.getAdvanceStartTime();
        this.advanceEndTime = campaign.getAdvanceEndTime();
        this.active = campaign.getActive();
        String excludeStoresDesc = campaign.getExcludeStores();
        ArrayList excludeStores = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)excludeStoresDesc)) {
            excludeStores = Lists.newArrayList((Object[])excludeStoresDesc.split(","));
        }
        this.excludeStores = excludeStores;
        this.memberType = campaign.getMemberType();
    }

    public static List<PsCampaignVO> transfer(List<Campaign> domains) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(domains)) {
            for (Campaign domain : domains) {
                PsCampaignVO vo = new PsCampaignVO(domain);
                result.add(vo);
            }
        }
        return result;
    }

    public Map<String, Object> toMap() {
        HashedMap map = new HashedMap();
        map.put("id", this.id);
        map.put("code", this.code);
        map.put("name", this.name);
        map.put("title", this.title);
        map.put("state", this.state);
        map.put("productScopeId", this.productScopeId);
        map.put("discountTypeId", this.discountTypeId);
        if (this.discountTypeName != null) {
            map.put("discountTypeName", this.discountTypeName);
        }
        map.put("crossBorderFlag", this.crossBorderFlag);
        map.put("accessWayIds", this.accessWayIds);
        map.put("memberLevels", this.memberLevels);
        map.put("buIds", this.buIds);
        map.put("startTime", this.startTime);
        map.put("expireTime", this.expireTime);
        map.put("advance", this.advance);
        map.put("advanceStartTime", this.advanceStartTime);
        map.put("advanceEndTime", this.advanceEndTime);
        map.put("active", this.active);
        map.put("excludeStores", this.excludeStores);
        map.put("excludeProductIds", this.excludeProductIds);
        map.put("excludeSukCodes", this.excludeSukCodes);
        map.put("memberType", this.memberType);
        return map;
    }

    private List<Integer> splitIds(String str) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{str})) {
            String[] idArr;
            for (String id : idArr = str.split(",")) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id})) continue;
                try {
                    ids.add(Integer.valueOf(id));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ids;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getProductScopeId() {
        return this.productScopeId;
    }

    public void setProductScopeId(Integer productScopeId) {
        this.productScopeId = productScopeId;
    }

    public Integer getDiscountTypeId() {
        return this.discountTypeId;
    }

    public void setDiscountTypeId(Integer discountTypeId) {
        this.discountTypeId = discountTypeId;
    }

    public Integer getCrossBorderFlag() {
        return this.crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public String getDiscountTypeName() {
        return this.discountTypeName;
    }

    public void setDiscountTypeName(String discountTypeName) {
        this.discountTypeName = discountTypeName;
    }

    public List<Integer> getAccessWayIds() {
        return this.accessWayIds;
    }

    public void setAccessWayIds(List<Integer> accessWayIds) {
        this.accessWayIds = accessWayIds;
    }

    public List<Integer> getMemberLevels() {
        return this.memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getAdvance() {
        return this.advance;
    }

    public void setAdvance(Integer advance) {
        this.advance = advance;
    }

    public Date getAdvanceStartTime() {
        return this.advanceStartTime;
    }

    public void setAdvanceStartTime(Date advanceStartTime) {
        this.advanceStartTime = advanceStartTime;
    }

    public Date getAdvanceEndTime() {
        return this.advanceEndTime;
    }

    public void setAdvanceEndTime(Date advanceEndTime) {
        this.advanceEndTime = advanceEndTime;
    }

    public Integer getActive() {
        return this.active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<Long> getExcludeProductIds() {
        return this.excludeProductIds;
    }

    public void setExcludeProductIds(List<Long> excludeProductIds) {
        this.excludeProductIds = excludeProductIds;
    }

    public List<String> getExcludeSukCodes() {
        return this.excludeSukCodes;
    }

    public void setExcludeSukCodes(List<String> excludeSukCodes) {
        this.excludeSukCodes = excludeSukCodes;
    }

    public List<String> getExcludeStores() {
        return this.excludeStores;
    }

    public void setExcludeStores(List<String> excludeStores) {
        this.excludeStores = excludeStores;
    }

    public List<Integer> getBuIds() {
        return this.buIds;
    }

    public void setBuIds(List<Integer> buIds) {
        this.buIds = buIds;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }
}

