package com.thebeastshop.scm.po;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import pers.richard.ormybatis.domain.po.IdPo;

public class RecommendProductAuto extends IdPo {
	private String sourceProductCode;
	private String recommendProductCode;
	private Integer sort;
	private String position;
	private String type;
	private Integer status;//0屏蔽 1启用',
	private Date updateTime;
	private Date createTime;
	
	public RecommendProductAuto(){}
	
	public final static String
		F_SOURCE_PRODUCT_CODE = "source_product_code",
		F_RECOMMEND_PRODUCT_CODE = "recommend_product_code",
		F_SORT = "sort",
		F_POSITION = "position",
		F_TYPE = "type",
		F_STATUS = "status",
		F_UPDATE_TIME = "update_time",
		F_CREATE_TIME = "create_time";
	
	/** 位置 */
	public enum Position{
		ADD_ON_ITEM("免邮凑单推荐"),
		PROD_DETAIL("商品详细推荐");
		
		public String cn;
		private Position(String cn){
			this.cn = cn;
		}
		
		public static Map<String, String> getMap(){
			Map<String, String> map = new LinkedHashMap<>();
			for (Position position : Position.values()) {
				map.put(position.name(), position.cn);
			}
			return map;
		}
		
	}
	
	public enum Type{
		ARTIFICIAL,//人工推荐
		AUTO;//自动推荐
	}
	
	public String getSourceProductCode() {return sourceProductCode;}
	public void setSourceProductCode(String sourceProductCode) {this.sourceProductCode = sourceProductCode;}

	public String getRecommendProductCode() {return recommendProductCode;}
	public void setRecommendProductCode(String recommendProductCode) {this.recommendProductCode = recommendProductCode;}

	public Integer getSort() {return sort;}
	public void setSort(Integer sort) {this.sort = sort;}

	public String getPosition() {return position;}
	public void setPosition(String position) {this.position = position;}

	public String getType() {return type;}
	public void setType(String type) {this.type = type;}

	public Integer getStatus() {return status;}
	public void setStatus(Integer status) {this.status = status;}
	
	public Date getUpdateTime() {return updateTime;}
	public void setUpdateTime(Date updateTime) {this.updateTime = updateTime;}

	public Date getCreateTime() {return createTime;}
	public void setCreateTime(Date createTime) {this.createTime = createTime;}
}