package com.thebeastshop.scm.po;

import java.util.Date;

import pers.richard.ormybatis.domain.po.IdPo;
/**
 * t_op_so_package
 * 
 * 包裹表
 * @author 徐玲玲
 *
 * 2016年8月25日
 */
public class SoPackage extends IdPo {
	private Integer salesOrderId;
	private String dispatchWarehouseCode;
	private String code;
	private Integer packageStatus;
	private Integer deliveryType;
	private Date orderMakeTime;
	private Date expectReceiveDate;
	private Date planedDeliveryDate;
	private Date deliveryTime;
	private String limitDeliveryTimeDesc;
	private Date receiveTime;
	private Integer cardType;
	private String cardContent;
	private String batchNo;
	private String csHint;
	private String remark;
	private Integer oid;
	private Integer receiptstatus;
	private Integer crossBorderFlag;
	private Integer wmsCmdShortage;
	private Date haitaoPlayDeliveryDate;
	private Integer clearanceWay;
	private Integer autoMake;
	
	public SoPackage(){}
	
	public final static String
		F_SALES_ORDER_ID = "sales_order_id",
		F_DISPATCH_WAREHOUSE_CODE = "dispatch_warehouse_code",
		F_CODE = "code",
		F_PACKAGE_STATUS = "package_status",
		F_DELIVERY_TYPE = "delivery_type",
		F_ORDER_MAKE_TIME = "order_make_time",
		F_EXPECT_RECEIVE_DATE = "expect_receive_date",
		F_PLANED_DELIVERY_DATE = "planed_delivery_date",
		F_DELIVERY_TIME = "delivery_time",
		F_LIMIT_DELIVERY_TIME_DESC = "limit_delivery_time_desc",
		F_RECEIVE_TIME = "receive_time",
		F_CARD_TYPE = "card_type",
		F_CARD_CONTENT = "card_content",
		F_BATCH_NO = "batch_no",
		F_CS_HINT = "cs_hint",
		F_REMARK = "remark",
		F_OID = "oid",
		F_RECEIPTSTATUS = "receiptstatus",
		F_CROSS_BORDER_FLAG = "cross_border_flag",
		F_WMS_CMD_SHORTAGE = "wms_cmd_shortage",
		F_HAITAO_PLAY_DELIVERY_DATE = "haitao_play_delivery_date",
		F_CLEARANCE_WAY = "clearance_way",
		F_AUTO_MAKE = "auto_make";
	
	 /**
     * 包裹状态  packageStatus
     */
    public static final Integer PACKAGE_STATUS_UNSENT_CANCEL = -1;		// 未发货取消
    public static final Integer PACKAGE_STATUS_DEFAULT = 10;			// 初始
    public static final Integer PACKAGE_STATUS_WAITING_MAKE = 11;		// 待制单
    public static final Integer PACKAGE_STATUS_WAITING_SEND = 12;		// 待发货
    public static final Integer PACKAGE_STATUS_WAITING_RECEIVE = 13;	// 待收货
    public static final Integer PACKAGE_STATUS_ALREADY_RECEIVE = 14;	// 已收货

    /**
     * 卡片类型  cardType
     */
    public static final Integer CARD_TYPE_NULL = 0;			// 不需要
    public static final Integer CARD_TYPE_BLANK_ = 1;		// 空白
    public static final Integer CARD_TYPE_GHOSTWRITE = 2;	//代写

    /**
     * 配送方式 deliveryType
     */
    public static final Integer DELIVERY_TYPE_EXPRESS = 1;	// 快递
    public static final Integer DELIVERY_TYPE_NOT_EXPRESS = 0;	// 非快递
    
    /**
     * 通关方式 clearanceWay （0：未知，1：BC，2：个人）
     */
    public static final Integer CLEARANCE_WAY_UNKNOWN= 0;	// 未知
    public static final Integer CLEARANCE_WAY_BC= 1;		// BC
    public static final Integer CLEARANCE_WAY_PERSONAL = 2;	// 个人

	public Integer getSalesOrderId() {return salesOrderId;}
	public void setSalesOrderId(Integer salesOrderId) {this.salesOrderId = salesOrderId;}

	public String getDispatchWarehouseCode() {return dispatchWarehouseCode;}
	public void setDispatchWarehouseCode(String dispatchWarehouseCode) {this.dispatchWarehouseCode = dispatchWarehouseCode;}

	public String getCode() {return code;}
	public void setCode(String code) {this.code = code;}

	public Integer getPackageStatus() {return packageStatus;}
	public void setPackageStatus(Integer packageStatus) {this.packageStatus = packageStatus;}

	public Integer getDeliveryType() {return deliveryType;}
	public void setDeliveryType(Integer deliveryType) {this.deliveryType = deliveryType;}

	public Date getOrderMakeTime() {return orderMakeTime;}
	public void setOrderMakeTime(Date orderMakeTime) {this.orderMakeTime = orderMakeTime;}

	public Date getExpectReceiveDate() {return expectReceiveDate;}
	public void setExpectReceiveDate(Date expectReceiveDate) {this.expectReceiveDate = expectReceiveDate;}

	public Date getPlanedDeliveryDate() {return planedDeliveryDate;}
	public void setPlanedDeliveryDate(Date planedDeliveryDate) {this.planedDeliveryDate = planedDeliveryDate;}

	public Date getDeliveryTime() {return deliveryTime;}
	public void setDeliveryTime(Date deliveryTime) {this.deliveryTime = deliveryTime;}

	public String getLimitDeliveryTimeDesc() {return limitDeliveryTimeDesc;}
	public void setLimitDeliveryTimeDesc(String limitDeliveryTimeDesc) {this.limitDeliveryTimeDesc = limitDeliveryTimeDesc;}

	public Date getReceiveTime() {return receiveTime;}
	public void setReceiveTime(Date receiveTime) {this.receiveTime = receiveTime;}

	public Integer getCardType() {return cardType;}
	public void setCardType(Integer cardType) {this.cardType = cardType;}

	public String getCardContent() {return cardContent;}
	public void setCardContent(String cardContent) {this.cardContent = cardContent;}

	public String getBatchNo() {return batchNo;}
	public void setBatchNo(String batchNo) {this.batchNo = batchNo;}

	public String getCsHint() {return csHint;}
	public void setCsHint(String csHint) {this.csHint = csHint;}

	public String getRemark() {return remark;}
	public void setRemark(String remark) {this.remark = remark;}

	public Integer getOid() {return oid;}
	public void setOid(Integer oid) {this.oid = oid;}

	public Integer getReceiptstatus() {return receiptstatus;}
	public void setReceiptstatus(Integer receiptstatus) {this.receiptstatus = receiptstatus;}

	public Integer getCrossBorderFlag() {return crossBorderFlag;}
	public void setCrossBorderFlag(Integer crossBorderFlag) {this.crossBorderFlag = crossBorderFlag;}

	public Integer getWmsCmdShortage() {return wmsCmdShortage;}
	public void setWmsCmdShortage(Integer wmsCmdShortage) {this.wmsCmdShortage = wmsCmdShortage;}

	public Date getHaitaoPlayDeliveryDate() {return haitaoPlayDeliveryDate;}
	public void setHaitaoPlayDeliveryDate(Date haitaoPlayDeliveryDate) {this.haitaoPlayDeliveryDate = haitaoPlayDeliveryDate;}

	public Integer getClearanceWay() {return clearanceWay;}
	public void setClearanceWay(Integer clearanceWay) {this.clearanceWay = clearanceWay;}

	public Integer getAutoMake() {return autoMake;}
	public void setAutoMake(Integer autoMake) {this.autoMake = autoMake;}
}