package com.thebeastshop.scm.po;

import java.math.BigDecimal;
import java.util.Date;

import pers.richard.ormybatis.domain.po.IdPo;

public class SoInvoiceInfo extends IdPo {
	private Integer salesOrderId;
	private Integer invoiceType;
	private String invoiceTitle;
	private BigDecimal invoiceAmount;
	private Integer districtId;
	private String address;
	private String zipCode;
	private String receiver;
	private String receiverPhone;
	private Integer invoiceStatus;
	private Date applyTime;
	private Integer applyOperatorId;
	private String applyOperatorName;
	private Date makeTime;
	private Date deliveryTime;
	private String deliveryCode;
	private Integer isEmergency;
	private String innerRemark;
	private String financeRemark;
	private String invoiceNumber;

	private Integer expressType;			// 快递类型（不存数据库）

	public SoInvoiceInfo(){}

	public final static String
		F_SALES_ORDER_ID = "sales_order_id",
		F_INVOICE_TYPE = "invoice_type",
		F_INVOICE_TITLE = "invoice_title",
		F_INVOICE_AMOUNT = "invoice_amount",
		F_DISTRICT_ID = "district_id",
		F_ADDRESS = "address",
		F_ZIP_CODE = "zip_code",
		F_RECEIVER = "receiver",
		F_RECEIVER_PHONE = "receiver_phone",
		F_INVOICE_STATUS = "invoice_status",
		F_APPLY_TIME = "apply_time",
		F_APPLY_OPERATOR_ID = "apply_operator_id",
		F_APPLY_OPERATOR_NAME = "apply_operator_name",
		F_MAKE_TIME = "make_time",
		F_DELIVERY_TIME = "delivery_time",
		F_DELIVERY_CODE = "delivery_code",
		F_IS_EMERGENCY = "is_emergency",
		F_INNER_REMARK = "inner_remark",
		F_FINANCE_REMARK = "finance_remark",
		F_INVOICE_NUMBER = "invoice_number";
	

	 // 发票状态，0初始1待开2已开
    public static final Integer INVOICE_ORIGINAL = 0;
    public static final Integer INVOICE_TOBE = 1;
    public static final Integer INVOICE_OVER = 2;

	public Integer getSalesOrderId() {return salesOrderId;}
	public void setSalesOrderId(Integer salesOrderId) {this.salesOrderId = salesOrderId;}

	public Integer getInvoiceType() {return invoiceType;}
	public void setInvoiceType(Integer invoiceType) {this.invoiceType = invoiceType;}

	public String getInvoiceTitle() {return invoiceTitle;}
	public void setInvoiceTitle(String invoiceTitle) {this.invoiceTitle = invoiceTitle;}

	public BigDecimal getInvoiceAmount() {return invoiceAmount;}
	public void setInvoiceAmount(BigDecimal invoiceAmount) {this.invoiceAmount = invoiceAmount;}

	public Integer getDistrictId() {return districtId;}
	public void setDistrictId(Integer districtId) {this.districtId = districtId;}

	public String getAddress() {return address;}
	public void setAddress(String address) {this.address = address;}

	public String getZipCode() {return zipCode;}
	public void setZipCode(String zipCode) {this.zipCode = zipCode;}

	public String getReceiver() {return receiver;}
	public void setReceiver(String receiver) {this.receiver = receiver;}

	public String getReceiverPhone() {return receiverPhone;}
	public void setReceiverPhone(String receiverPhone) {this.receiverPhone = receiverPhone;}

	public Integer getInvoiceStatus() {return invoiceStatus;}
	public void setInvoiceStatus(Integer invoiceStatus) {this.invoiceStatus = invoiceStatus;}

	public Date getApplyTime() {return applyTime;}
	public void setApplyTime(Date applyTime) {this.applyTime = applyTime;}

	public Integer getApplyOperatorId() {return applyOperatorId;}
	public void setApplyOperatorId(Integer applyOperatorId) {this.applyOperatorId = applyOperatorId;}

	public String getApplyOperatorName() {return applyOperatorName;}
	public void setApplyOperatorName(String applyOperatorName) {this.applyOperatorName = applyOperatorName;}

	public Date getMakeTime() {return makeTime;}
	public void setMakeTime(Date makeTime) {this.makeTime = makeTime;}

	public Date getDeliveryTime() {return deliveryTime;}
	public void setDeliveryTime(Date deliveryTime) {this.deliveryTime = deliveryTime;}

	public String getDeliveryCode() {return deliveryCode;}
	public void setDeliveryCode(String deliveryCode) {this.deliveryCode = deliveryCode;}

	public Integer getIsEmergency() {return isEmergency;}
	public void setIsEmergency(Integer isEmergency) {this.isEmergency = isEmergency;}

	public String getInnerRemark() {return innerRemark;}
	public void setInnerRemark(String innerRemark) {this.innerRemark = innerRemark;}

	public String getFinanceRemark() {return financeRemark;}
	public void setFinanceRemark(String financeRemark) {this.financeRemark = financeRemark;}

	public String getInvoiceNumber() {return invoiceNumber;}
	public void setInvoiceNumber(String invoiceNumber) {this.invoiceNumber = invoiceNumber;}

	public Integer getExpressType() {
		return expressType;
	}
	public void setExpressType(Integer expressType) {
		this.expressType = expressType;
	}
	// 发票状态，0初始1待开2已开
	public String getInvoiceStatusName() {
        return 	invoiceStatus == null ? "" :
        		invoiceStatus.equals(INVOICE_ORIGINAL) ? "初始" :
        		invoiceStatus.equals(INVOICE_TOBE) ? "待开票" :
        		invoiceStatus.equals(INVOICE_OVER) ? "已开票": "";
    }

	// 快递类型
    public String getExpressTypeName() {
        return 	expressType == null ? "" :
        		expressType.equals(SoPackageDeliveryInfo.EXPRESS_TYPE_SHOP) ? "店送" :
                expressType.equals(SoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX) ? "联邦" :
                expressType.equals(SoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR) ? "顺丰(空运)" :
                expressType.equals(SoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND) ? "顺丰(陆运)":
                expressType.equals(SoPackageDeliveryInfo.EXPRESS_TYPE_YTO) ? "圆通" : 
                expressType.equals(SoPackageDeliveryInfo.EXPRESS_TYPE_SELF) ? "自送":
                expressType.equals(SoPackageDeliveryInfo.EXPRESS_TYPE_HT) ? "海淘顺丰": "";
    }
}