package com.thebeastshop.scm.po;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import pers.richard.ormybatis.domain.po.IdPo;

public class ProdDynmCont extends IdPo {
	private Integer productId;
	private String titleEn;
	private String titleCn;
	private String content;
	private Integer sort;
	private String contentType;
	
	public ProdDynmCont(){}
	
	public final static String
		F_PRODUCT_ID = "PRODUCT_ID",
		F_TITLE_EN = "TITLE_EN",
		F_TITLE_CN = "TITLE_CN",
		F_CONTENT = "CONTENT",
		F_SORT = "SORT",
		F_CONTENT_TYPE = "CONTENT_TYPE";
	
	public Integer getProductId() {return productId;}
	public void setProductId(Integer productId) {this.productId = productId;}

	public String getTitleEn() {return titleEn;}
	public void setTitleEn(String titleEn) {this.titleEn = titleEn;}

	public String getTitleCn() {return titleCn;}
	public void setTitleCn(String titleCn) {this.titleCn = titleCn;}

	public String getContent() {return content;}
	public void setContent(String content) {
		String[] array = StringUtils.split(content,  "#");
		if (ArrayUtils.getLength(array) > 1) {
			content = "<p>" + StringUtils.join(array, "</p><p>") + "</p>";
		}
		this.content = content;
	}

	public Integer getSort() {return sort;}
	public void setSort(Integer sort) {this.sort = sort;}

	public String getContentType() {return contentType;}
	public void setContentType(String contentType) {this.contentType = contentType;}
	

	public enum ContentType {
		recommend_reason("recommend_reason","推荐理由","STYLE NOTES"),
		product_detail("product_detail","品牌故事","BRAND STORY"),
	    short_description("short_description","商品详情","DETAILS"),
	    create_feel("create_feel","创作灵感 ","INSPIRATION"),
	    florid("florid","花语","THE LANGUAGE OF FLOWERS"),
	    user_guide("user_guide","使用说明","USING NOTES"),
	    flower_size_instruction("flower_size_instruction","鲜花尺寸说明",""),
	    washing_maintenance("washing_maintenance","洗涤和保养","DETAILS & CARES"),
	    customization_insturction("customization_insturction","定制说明","SPECIAL NOTES"),
	    maintenance_insturction("maintenance_insturction","保养说明","CARING"),
	    flower_send_instruction ("flower_send_instruction","促销或特别说明",""),
	    transport_instruction("transport_instruction","运输说明","DELIVERY"),
	    rma_instruction("rma_instruction","退换货说明","RETURN & EXCHANGE"),
	    cross_border("cross_border","跨境购","CROSS BORDER");
	    
	    private String type, nameCn, nameEn;

	    private ContentType(String type, String nameCn, String nameEn) {
	        this.type = type;
	        this.nameCn = nameCn;
	        this.nameEn = nameEn;
	    }
	    
	    public static ContentType byType(String type) {
	        for (ContentType contentType : ContentType.values()) {
	            if (StringUtils.equals(type, contentType.type)) {
	                return contentType;
	            }
	        }
	        return null;
	    }
	    
	    public String getType() {return type;}
	    public void setType(String type) { this.type = type;}

	    public String getNameCn() {return nameCn;}
	    public void setNameCn(String nameCn) {this.nameCn = nameCn;}

	    public String getNameEn() {return nameEn;}
	    public void setNameEn(String nameEn) { this.nameEn = nameEn;}
	}
}