package com.thebeastshop.scm.po;

import java.util.Date;

import pers.richard.ormybatis.domain.po.IdPo;

public class ProductUpDownRecord extends IdPo {
	private Integer opChnCanSaleProdId;
	private String status;
	private String downReason = "";
	private String isTimer;
	private Integer createUserId;
	private String createUserName;
	private Date createAt;
	
	public ProductUpDownRecord(){}
	
	public final static String
		F_OP_CHN_CAN_SALE_PROD_ID = "OP_CHN_CAN_SALE_PROD_ID",
		F_STATUS = "status",
		F_DOWN_REASON = "down_reason",
		F_IS_TIMER = "is_timer",
		F_CREATE_USER_ID = "create_user_id",
		F_CREATE_USER_NAME = "create_user_name",
		F_CREATE_AT = "create_at";
	
	public Integer getOpChnCanSaleProdId() {return opChnCanSaleProdId;}
	public void setOpChnCanSaleProdId(Integer opChnCanSaleProdId) {this.opChnCanSaleProdId = opChnCanSaleProdId;}
	
	public String getStatus() {return status;}
	public void setStatus(String status) {this.status = status;}

	public String getDownReason() {return downReason;}
	public void setDownReason(String downReason) {this.downReason = downReason;}

	public String getIsTimer() {return isTimer;}
	public void setIsTimer(String isTimer) {this.isTimer = isTimer;}
	
	public Integer getCreateUserId() {return createUserId;}
	public void setCreateUserId(Integer createUserId) {this.createUserId = createUserId;}

	public String getCreateUserName() {return createUserName;}
	public void setCreateUserName(String createUserName) {this.createUserName = createUserName;}

	public Date getCreateAt() {return createAt;}
	public void setCreateAt(Date createAt) {this.createAt = createAt;}
	
	public enum Status{
		UP("上架"),
		DOWN("下架"),
		APPROVAL("审批"),
		WAITSHELF("待上架"),
		WAITDOWN("待下架"),
		SYSREJECTED("系统驳回"),
		MANREJECTED("人工驳回");
		
		public String cn;
		private Status(String cn) {
			this.cn = cn;
		}
		
		public static Status by(String s){
			for (Status status : Status.values()) {
				if (status.name().equalsIgnoreCase(s)) {
					return status;
				}
			}
			return null;
		}
	}
}