package com.thebeastshop.scm.es;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class PsChnProdSaleSku extends PsBaseVO {
	
	public PsChnProdSaleSku() {}
	
	public PsChnProdSaleSku(String chnCode, String canSaleSku) {
		this.chnCode = chnCode;
		List<String> skuList = Arrays.asList(StringUtils.split(canSaleSku,","));
        List<String> canSkuList = new ArrayList<>();
        for (String skuCode : skuList) {
            if (StringUtils.isNotBlank(skuCode) && !skuCode.equals("__")) {
                canSkuList.add(skuCode);
            }
        }
        this.canSkus = canSkuList;
	}

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashedMap();
        map.put("chnCode", chnCode);
        map.put("canSkus", canSkus);
        int size = getSize();
        map.put("empty", size == 0 ? 1 : 0);
        return super.toMap();
    }

    /**
     *  渠道编码
     */
    private String chnCode;

    private List<String> canSkus = new ArrayList<>();

    public String getChnCode() {
        return chnCode;
    }

    public void setChnCode(String chnCode) {
        this.chnCode = chnCode;
    }

    public List<String> getCanSkus() {
        return canSkus;
    }

    public void setCanSkus(List<String> canSkus) {
        this.canSkus = canSkus;
    }

    public Integer getSize() {
        if (canSkus == null) return 0;
        return canSkus.size();
    }

    public Integer getEmpty() {
        return getSize() == 0 ? 1 : 0;
    }
}
