package com.thebeastshop.scm.es;

import org.apache.commons.collections.map.HashedMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by gensheng.ye on 2017/11/20.
 */
public class PsCategoryCampaignVO extends PsUpdateVO  {

    private Long id;
    private Integer psCampaignVOSize;
    private List<PsCampaignVO> psCampaignVOs;


    /**
     * 是否海淘
     * 0.非海淘 1.海淘 2.不限制
     */
    private Integer crossBorderFlag;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }


    public List<PsCampaignVO> getPsCampaignVOs() {
        return psCampaignVOs;
    }

    public void setPsCampaignVOs(List<PsCampaignVO> psCampaignVOs) {
        this.psCampaignVOs = psCampaignVOs;
    }

    public Integer getPsCampaignVOSize() {
        return psCampaignVOSize;
    }

    public void setPsCampaignVOSize(Integer psCampaignVOSize) {
        this.psCampaignVOSize = psCampaignVOSize;
    }




    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashedMap();
        map.put("id",id);
        map.put("crossBorderFlag",crossBorderFlag);

        map.put("psCampaignVOSize",psCampaignVOSize);
        if (psCampaignVOs != null){
            List<Map> mapPsCampaignVOs = new ArrayList<>();
            for(PsCampaignVO psCampaignVO : psCampaignVOs){
                mapPsCampaignVOs.add(psCampaignVO.toMap());
            }
            map.put("psCampaignVOs",mapPsCampaignVOs);
        }
        return map;
    }
}


