package com.thebeastshop.scm.cond;

import pers.richard.ormybatis.domain.paging.PagingParam;

public class BasePageCond extends PagingParam{

	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;

	public String getCriteriaStr() {
        if (super.getPage() == null) {
            return "";
        }
        Integer pagestart = getPageStart();

        return new StringBuilder(" LIMIT ").append(pagestart).append(",").append(super.getSize()).append("  ").toString();
    }
	
	public int getPageStart() {
        return (super.getPage() > 0 ? (super.getPage() - 1) * super.getSize() : 0);
    }
	
}
