package com.thebeastshop.scm.vo.interest;

import java.util.Date;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.scm.po.InterestGoodsSku;

/**
 * 获取权益接口VO 
 * @author donghui
 */
public class InterestGoodsGetVO extends AbstractDomain {
	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;
	
	private Integer interestGoodsId;
	private String procutCode;
	private Integer isFreePost;//是否包邮
	private Date cashStartTime;//兑换开始时间
	private Date cashEndTime;//兑换结束时间
	private Integer interestGoodsSkuId;//默认的权益sku表id
	private String skuCode;//默认的权益sku code
	private String skuNameCn;//默认的权益sku中文名
	private Integer memberId;//会员ID
	
	public InterestGoodsGetVO() {}
	
	public InterestGoodsGetVO(InterestGoods interestGoods, InterestGoodsSku interestGoodsSku) {
		this.interestGoodsId = interestGoods.getId();
		this.procutCode = interestGoods.getProdCode();
		this.isFreePost = interestGoods.getIsFreePost();
		this.cashStartTime = interestGoods.getCashStartTime();
		this.cashEndTime = interestGoods.getCashEndTime();
		
		this.interestGoodsSkuId = interestGoodsSku.getId();
		this.skuCode = interestGoodsSku.getSkuCode();
		this.skuNameCn = interestGoodsSku.getSkuNameCn();
	}

	public Integer getInterestGoodsId() {
		return interestGoodsId;
	}

	public void setInterestGoodsId(Integer interestGoodsId) {
		this.interestGoodsId = interestGoodsId;
	}

	public String getProcutCode() {
		return procutCode;
	}

	public void setProcutCode(String procutCode) {
		this.procutCode = procutCode;
	}

	public Integer getIsFreePost() {
		return isFreePost;
	}

	public void setIsFreePost(Integer isFreePost) {
		this.isFreePost = isFreePost;
	}

	public Date getCashStartTime() {
		return cashStartTime;
	}

	public void setCashStartTime(Date cashStartTime) {
		this.cashStartTime = cashStartTime;
	}

	public Date getCashEndTime() {
		return cashEndTime;
	}

	public void setCashEndTime(Date cashEndTime) {
		this.cashEndTime = cashEndTime;
	}

	public Integer getInterestGoodsSkuId() {
		return interestGoodsSkuId;
	}

	public void setInterestGoodsSkuId(Integer interestGoodsSkuId) {
		this.interestGoodsSkuId = interestGoodsSkuId;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public String getSkuNameCn() {
		return skuNameCn;
	}

	public void setSkuNameCn(String skuNameCn) {
		this.skuNameCn = skuNameCn;
	}

	public Integer getMemberId() {
		return memberId;
	}

	public void setMemberId(Integer memberId) {
		this.memberId = memberId;
	}
	
}
