package com.thebeastshop.scm.po;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import pers.richard.ormybatis.domain.po.IdPo;

public class Brand extends IdPo {
	private String name;
	private String nameCn;
	private Date createTime;
	private String description;
	private Integer countryId;
	private Integer fileId;
	private Integer isOwn;
	private Date trademarkStart;
	private Date trademarkEnd;
	private Integer brandStatus;
	
	public Brand(){}
	
	public final static String
		F_NAME = "NAME",
		F_NAME_CN = "NAME_CN",
		F_CREATE_TIME = "CREATE_TIME",
		F_DESCRIPTION = "DESCRIPTION",
		F_COUNTRY_ID = "COUNTRY_ID",
		F_FILE_ID = "FILE_ID",
		F_IS_OWN = "IS_OWN",
		F_TRADEMARK_START = "TRADEMARK_START",
		F_TRADEMARK_END = "TRADEMARK_END",
		F_BRAND_STATUS = "BRAND_STATUS";
	
	/**
	 * 审核状态
	 */
	public enum BrandStatus {

		UNAUDIT(0, "待提交"), MANAGE_APPROVAL(1, "待品类经理审批"), LAW_APPROVAL(2, "待法务审"), REJECT(-1, "驳回"), FINISHED(3, "审批完成");
		
		public Integer value;
		public String cn;
		
		private BrandStatus(Integer value, String cn){
			this.value = value;
			this.cn = cn;
		}
		
		public static Map<Integer, String> getMap(){
			Map<Integer, String> result = new LinkedHashMap<>();
			for (BrandStatus status : BrandStatus.values()) {
				result.put(status.value, status.cn);
			}
			return result;
		}
	}

	

	public String getName() {return name;}
	public void setName(String name) {this.name = name;}

	public String getNameCn() {return nameCn;}
	public void setNameCn(String nameCn) {this.nameCn = nameCn;}

	public Date getCreateTime() {return createTime;}
	public void setCreateTime(Date createTime) {this.createTime = createTime;}

	public String getDescription() {return description;}
	public void setDescription(String description) {this.description = description;}

	public Integer getCountryId() {return countryId;}
	public void setCountryId(Integer countryId) {this.countryId = countryId;}

	public Integer getFileId() {return fileId;}
	public void setFileId(Integer fileId) {this.fileId = fileId;}

	public Integer getIsOwn() {return isOwn;}
	public void setIsOwn(Integer isOwn) {this.isOwn = isOwn;}

	public Date getTrademarkStart() {return trademarkStart;}
	public void setTrademarkStart(Date trademarkStart) {this.trademarkStart = trademarkStart;}

	public Date getTrademarkEnd() {return trademarkEnd;}
	public void setTrademarkEnd(Date trademarkEnd) {this.trademarkEnd = trademarkEnd;}

	public Integer getBrandStatus() {return brandStatus;}
	public void setBrandStatus(Integer brandStatus) {this.brandStatus = brandStatus;}
}