package com.thebeastshop.scm.vo.interest;

import java.util.Date;
import java.util.List;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.InterestFree;
import com.thebeastshop.scm.po.InterestFreeProduct;

/**
 * 免邮权益VO
 * @Class Name InterestFreeVO
 * @Author Xiang.Gao
 */
public class InterestFreeVO extends AbstractDomain{

	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;

	private Integer id;
	
	private Integer provideId;
	
	private Integer memberId;
	
	private String interestFreeName;
	
	private Integer productScope;
	
	private String productScopeName;
	
	private Integer crossBorderFlag;
	
	private String AccessWay;
	
	private Integer useTimeType;
	
	private Date useBeginDate;
	
	private Date useEndDate;
	
	private Integer provideAfterDay;
	
	private String validateDateStr;
	
	private Integer freePostNum;
	
	private Integer receiveNum;
	
	private Integer signReceiveNum;
	
	private Integer receivedTotal;
	
	private String createUser;
	
	private Date createTime;
	
	private Date provideTime;
	
	private String provideChannel;
	
	private Integer useTotal;
	
	private List<InterestFreeProduct> interestFreeProduct;
	
	private List<Long> categories;
	
	private String confirmFlag;
	
	private Integer freeStatus;
	
	public InterestFreeVO(){
	}
	
	public InterestFreeVO(InterestFree interestFree) {
		this.id = interestFree.getId();
		this.interestFreeName = interestFree.getInterestFreeName();
		this.productScope = interestFree.getProductScope();
		this.crossBorderFlag = interestFree.getCrossBorderFlag();
		this.AccessWay = interestFree.getAccessWay();
		this.useTimeType = interestFree.getUseTimeType();
		this.useBeginDate = interestFree.getUseBeginDate();
		this.useEndDate = interestFree.getUseEndDate();
		this.provideAfterDay = interestFree.getProvideAfterDay();
		this.freePostNum = interestFree.getFreePostNum();
		this.receiveNum = interestFree.getReceiveNum();
		this.signReceiveNum = interestFree.getSignReceiveNum();
		this.receivedTotal = interestFree.getReceivedTotal();
		this.createUser = interestFree.getCreateUser();
		this.createTime = interestFree.getCreateTime();
	}
	
	public static InterestFree toInterstFree(InterestFreeVO vo) {
		InterestFree interestFree = new InterestFree();
		interestFree.setId(vo.getId());
		interestFree.setInterestFreeName(vo.getInterestFreeName());
		interestFree.setProductScope(vo.getProductScope());
		interestFree.setCrossBorderFlag(vo.getCrossBorderFlag());
		interestFree.setAccessWay(vo.getAccessWay());
		interestFree.setUseTimeType(vo.getUseTimeType());
		interestFree.setUseBeginDate(vo.getUseBeginDate());
		interestFree.setUseEndDate(vo.getUseEndDate());
		interestFree.setProvideAfterDay(vo.getProvideAfterDay());
		interestFree.setFreePostNum(vo.getFreePostNum() == null ? 0 : vo.getFreePostNum());
		interestFree.setReceiveNum(vo.getReceiveNum() == null ? 0 : vo.getReceiveNum());
		interestFree.setSignReceiveNum(vo.getSignReceiveNum() == null ? 0 : vo.getSignReceiveNum());
		interestFree.setReceivedTotal(vo.getReceivedTotal() == null ? 0 : vo.getReceivedTotal());
		if(vo.getId() == null) {
			interestFree.setCreateUser(vo.getCreateUser());
			interestFree.setCreateTime(new Date());
		}
		return interestFree;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public Integer getProvideId() {
		return provideId;
	}

	public void setProvideId(Integer provideId) {
		this.provideId = provideId;
	}
	
	public Integer getMemberId() {
		return memberId;
	}

	public void setMemberId(Integer memberId) {
		this.memberId = memberId;
	}

	public String getInterestFreeName() {
		return interestFreeName;
	}

	public void setInterestFreeName(String interestFreeName) {
		this.interestFreeName = interestFreeName;
	}

	public Integer getProductScope() {
		return productScope;
	}

	public void setProductScope(Integer productScope) {
		this.productScope = productScope;
	}
	
	public String getProductScopeName() {
		return productScopeName;
	}

	public void setProductScopeName(String productScopeName) {
		this.productScopeName = productScopeName;
	}

	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	public String getAccessWay() {
		return AccessWay;
	}

	public void setAccessWay(String accessWay) {
		AccessWay = accessWay;
	}

	public Integer getUseTimeType() {
		return useTimeType;
	}

	public void setUseTimeType(Integer useTimeType) {
		this.useTimeType = useTimeType;
	}

	public Date getUseBeginDate() {
		return useBeginDate;
	}

	public void setUseBeginDate(Date useBeginDate) {
		this.useBeginDate = useBeginDate;
	}

	public Date getUseEndDate() {
		return useEndDate;
	}

	public void setUseEndDate(Date useEndDate) {
		this.useEndDate = useEndDate;
	}

	public Integer getProvideAfterDay() {
		return provideAfterDay;
	}

	public void setProvideAfterDay(Integer provideAfterDay) {
		this.provideAfterDay = provideAfterDay;
	}

	public String getValidateDateStr() {
		return validateDateStr;
	}

	public void setValidateDateStr(String validateDateStr) {
		this.validateDateStr = validateDateStr;
	}

	public Integer getFreePostNum() {
		return freePostNum;
	}

	public void setFreePostNum(Integer freePostNum) {
		this.freePostNum = freePostNum;
	}

	public Integer getReceiveNum() {
		return receiveNum;
	}

	public void setReceiveNum(Integer receiveNum) {
		this.receiveNum = receiveNum;
	}

	public Integer getSignReceiveNum() {
		return signReceiveNum;
	}

	public void setSignReceiveNum(Integer signReceiveNum) {
		this.signReceiveNum = signReceiveNum;
	}
	
	public Integer getReceivedTotal() {
		return receivedTotal;
	}

	public void setReceivedTotal(Integer receivedTotal) {
		this.receivedTotal = receivedTotal;
	}

	public String getCreateUser() {
		return createUser;
	}

	public void setCreateUser(String createUser) {
		this.createUser = createUser;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public Date getProvideTime() {
		return provideTime;
	}

	public void setProvideTime(Date provideTime) {
		this.provideTime = provideTime;
	}
	
	public String getProvideChannel() {
		return provideChannel;
	}

	public void setProvideChannel(String provideChannel) {
		this.provideChannel = provideChannel;
	}

	public Integer getUseTotal() {
		return useTotal;
	}

	public void setUseTotal(Integer useTotal) {
		this.useTotal = useTotal;
	}

	public List<InterestFreeProduct> getInterestFreeProduct() {
		return interestFreeProduct;
	}

	public void setInterestFreeProduct(List<InterestFreeProduct> interestFreeProduct) {
		this.interestFreeProduct = interestFreeProduct;
	}

	public List<Long> getCategories() {
		return categories;
	}

	public void setCategories(List<Long> categories) {
		this.categories = categories;
	}

	public String getConfirmFlag() {
		return confirmFlag;
	}

	public void setConfirmFlag(String confirmFlag) {
		this.confirmFlag = confirmFlag;
	}

	public Integer getFreeStatus() {
		return freeStatus;
	}

	public void setFreeStatus(Integer freeStatus) {
		this.freeStatus = freeStatus;
	}

}
