/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.es;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.es.PsAttributeValuePairVO;
import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.es.PsSkuVO;
import com.thebeastshop.scm.es.PsUpdateVO;
import com.thebeastshop.scm.po.ProdSku;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PsSpvVO
extends PsUpdateVO {
    private Integer spvId;
    private Integer productId;
    private String prodCode;
    private String skuCode;
    private Integer minAmount;
    private Integer combined;
    private String attrs;
    private BigDecimal salesPrice;
    private List<PsAttributeValuePairVO> attributeValuePairList;
    private List<Map> skuCombinationList = new ArrayList<Map>();
    private List<PsCampaignVO> campaignList;
    private Boolean isAvaile = null;

    public static boolean isAvaible(String chnCode, boolean combined, Map<String, String> canSaleSkuMap, Map<String, String> canSeeSkuMap, PsSpvVO spvVO) {
        if (spvVO.isAvaile != null) {
            return spvVO.isAvaile;
        }
        if (combined) {
            List<Map> scList = spvVO.getSkuCombinationList();
            if (CollectionUtils.isEmpty(scList)) {
                spvVO.isAvaile = false;
                return false;
            }
            for (Map sc : scList) {
                String skuCode = MapUtils.getString((Map)sc, (Object)"subSkuCode");
                if (PsSkuVO.isAvaible(chnCode, canSaleSkuMap, canSeeSkuMap, skuCode)) continue;
                spvVO.isAvaile = false;
                return false;
            }
            spvVO.isAvaile = true;
            return true;
        }
        spvVO.isAvaile = PsSkuVO.isAvaible(chnCode, canSaleSkuMap, canSeeSkuMap, spvVO.getSkuCode());
        return spvVO.isAvaile;
    }

    public PsSpvVO() {
    }

    public PsSpvVO(ProdSku ps) {
        this.spvId = ps.getId();
        this.productId = ps.getProductId();
        this.prodCode = ps.getProdCode();
        this.skuCode = ps.getSkuCode();
        this.minAmount = ps.getMinAmount();
        this.combined = ps.getCombined();
        this.attrs = ps.getAttrs();
        if (ps.getCombined() == null || ps.getCombined() == 0) {
            this.salesPrice = ps.getSingleSkuSalesPrice();
            if (StringUtils.isNotEmpty((CharSequence)ps.getSkuCategoryName())) {
                PsAttributeValuePairVO attributeValuePairVO = new PsAttributeValuePairVO();
                attributeValuePairVO.setAttrName(ps.getSkuCategoryDesc());
                attributeValuePairVO.setValue(ps.getSkuCategoryName());
                List<PsAttributeValuePairVO> attrValuePairList = Arrays.asList(attributeValuePairVO);
                this.setAttributeValuePairList(attrValuePairList);
            }
        } else {
            this.salesPrice = ps.getSalesPrice() != null ? ps.getSalesPrice() : BigDecimal.ZERO;
        }
    }

    public Map<String, Object> toMap() {
        HashedMap map = new HashedMap();
        map.put("spvId", this.spvId);
        map.put("productId", this.productId);
        map.put("prodCode", this.prodCode);
        map.put("skuCode", this.skuCode);
        map.put("minAmount", this.minAmount);
        map.put("combined", this.combined);
        if (this.attrs != null) {
            map.put("attrs", this.attrs);
        }
        if (this.salesPrice != null) {
            map.put("salesPrice", this.salesPrice);
        }
        if (this.attributeValuePairList != null) {
            ArrayList<Map> attrValuePairMapList = new ArrayList<Map>();
            for (PsAttributeValuePairVO attributeValuePairVO : this.attributeValuePairList) {
                attrValuePairMapList.add(attributeValuePairVO.toMap());
            }
            map.put("attributeValuePairList", attrValuePairMapList);
        }
        if (this.skuCombinationList != null) {
            map.put("skuCombinationList", this.skuCombinationList);
        }
        if (CollectionUtils.isNotEmpty(this.campaignList)) {
            ArrayList campaignListMap = Lists.newArrayList();
            for (PsCampaignVO item : this.campaignList) {
                campaignListMap.add(item.toMap());
            }
            map.put("campaignList", campaignListMap);
        }
        return map;
    }

    public Integer getSpvId() {
        return this.spvId;
    }

    public void setSpvId(Integer spvId) {
        this.spvId = spvId;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public String getProdCode() {
        return this.prodCode;
    }

    public void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public Integer getCombined() {
        return this.combined;
    }

    public void setCombined(Integer combined) {
        this.combined = combined;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public BigDecimal getSalesPrice() {
        return this.salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public List<PsAttributeValuePairVO> getAttributeValuePairList() {
        return this.attributeValuePairList;
    }

    public void setAttributeValuePairList(List<PsAttributeValuePairVO> attributeValuePairList) {
        this.attributeValuePairList = attributeValuePairList;
    }

    public List<Map> getSkuCombinationList() {
        return this.skuCombinationList;
    }

    public void setSkuCombinationList(List<Map> skuCombinationList) {
        this.skuCombinationList = skuCombinationList;
    }

    public List<PsCampaignVO> getCampaignList() {
        return this.campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }
}

