package com.thebeastshop.scm.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.thebeastshop.scm.po.SalesOrder;
import com.thebeastshop.scm.po.SoInvoiceInfo;
import com.thebeastshop.scm.vo.SoPackageVO;

import pers.richard.ormybatis.domain.core.AbstractDomain;

public class SalesOrderVO extends AbstractDomain {
	private Integer id;
	private String code;
	private String outerOrderCode;
	private String sourceSoCode;
	private String groupContractCode;
	private Integer salesOrderType;
	private Integer salesOrderStatus;
	private String channelCode;
	private String memberCode;
	private Integer createOperatorId;
	private String createOperatorName;
	private Date createTime;
	private Date cancelTime;
	private Date payTime;
	private Date auditTime;
	private BigDecimal totalAmount;
	private BigDecimal discountOnHead;
	private BigDecimal discountOnLine;
	private BigDecimal totalAmountAfterDiscount;
	private BigDecimal pointOnHead;
	private BigDecimal pointOnLine;
	private BigDecimal pointOnHeadDeduction;
	private BigDecimal pointOnLineDeduction;
	private BigDecimal serviceFeeAmount;
	private BigDecimal giftCardAmount;
	private BigDecimal needToPayAmount;
	private Integer paymentType;
	private Integer isAnonymous;
	private Integer needInvoice;
	private Integer isInvoiceInSamePackage;
	private String couponCode;
	private BigDecimal couponDiscountAmount;
	private String giftCardDesc;
	private String remark;
	private String innerRemark;
	private String foodSpecific;
	private Integer isForceAudit;
	private Integer isDownload;
	private String secondOrderSource;
	private Integer hideFlag;
	private String buyerNick;
	private Float crossBorderFee;
	private Integer crossBorderFlag;
	private String refundStatus;
	private String tradeNo;

	private List<SoPackageVO> soPackageVOList;		// 包裹集合
	private SoInvoiceInfo soInvoiceInfo;			// 发票信息

    private String channelName;						// 来源渠道名称
    private Integer channelType;					// 来源渠道类型
    
    private Boolean canCancleSku;					// 是否可取消部分商品

	public Integer getId() {
		return id;
	}
	public void setId(Integer id) {
		this.id = id;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getOuterOrderCode() {
		return outerOrderCode;
	}
	public void setOuterOrderCode(String outerOrderCode) {
		this.outerOrderCode = outerOrderCode;
	}
	public String getSourceSoCode() {
		return sourceSoCode;
	}
	public void setSourceSoCode(String sourceSoCode) {
		this.sourceSoCode = sourceSoCode;
	}
	public String getGroupContractCode() {
		return groupContractCode;
	}
	public void setGroupContractCode(String groupContractCode) {
		this.groupContractCode = groupContractCode;
	}
	public Integer getSalesOrderType() {
		return salesOrderType;
	}
	public void setSalesOrderType(Integer salesOrderType) {
		this.salesOrderType = salesOrderType;
	}
	public Integer getSalesOrderStatus() {
		return salesOrderStatus;
	}
	public void setSalesOrderStatus(Integer salesOrderStatus) {
		this.salesOrderStatus = salesOrderStatus;
	}
	public String getChannelCode() {
		return channelCode;
	}
	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}
	public String getMemberCode() {
		return memberCode;
	}
	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	public Integer getCreateOperatorId() {
		return createOperatorId;
	}
	public void setCreateOperatorId(Integer createOperatorId) {
		this.createOperatorId = createOperatorId;
	}
	public String getCreateOperatorName() {
		return createOperatorName;
	}
	public void setCreateOperatorName(String createOperatorName) {
		this.createOperatorName = createOperatorName;
	}
	public Date getCreateTime() {
		return createTime;
	}
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	public Date getCancelTime() {
		return cancelTime;
	}
	public void setCancelTime(Date cancelTime) {
		this.cancelTime = cancelTime;
	}
	public Date getPayTime() {
		return payTime;
	}
	public void setPayTime(Date payTime) {
		this.payTime = payTime;
	}
	public Date getAuditTime() {
		return auditTime;
	}
	public void setAuditTime(Date auditTime) {
		this.auditTime = auditTime;
	}
	public BigDecimal getTotalAmount() {
		return totalAmount;
	}
	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}
	public BigDecimal getDiscountOnHead() {
		return discountOnHead;
	}
	public void setDiscountOnHead(BigDecimal discountOnHead) {
		this.discountOnHead = discountOnHead;
	}
	public BigDecimal getDiscountOnLine() {
		return discountOnLine;
	}
	public void setDiscountOnLine(BigDecimal discountOnLine) {
		this.discountOnLine = discountOnLine;
	}
	public BigDecimal getTotalAmountAfterDiscount() {
		return totalAmountAfterDiscount;
	}
	public void setTotalAmountAfterDiscount(BigDecimal totalAmountAfterDiscount) {
		this.totalAmountAfterDiscount = totalAmountAfterDiscount;
	}
	public BigDecimal getPointOnHead() {
		return pointOnHead;
	}
	public void setPointOnHead(BigDecimal pointOnHead) {
		this.pointOnHead = pointOnHead;
	}
	public BigDecimal getPointOnLine() {
		return pointOnLine;
	}
	public void setPointOnLine(BigDecimal pointOnLine) {
		this.pointOnLine = pointOnLine;
	}
	public BigDecimal getPointOnHeadDeduction() {
		return pointOnHeadDeduction;
	}
	public void setPointOnHeadDeduction(BigDecimal pointOnHeadDeduction) {
		this.pointOnHeadDeduction = pointOnHeadDeduction;
	}
	public BigDecimal getPointOnLineDeduction() {
		return pointOnLineDeduction;
	}
	public void setPointOnLineDeduction(BigDecimal pointOnLineDeduction) {
		this.pointOnLineDeduction = pointOnLineDeduction;
	}
	public BigDecimal getServiceFeeAmount() {
		return serviceFeeAmount;
	}
	public void setServiceFeeAmount(BigDecimal serviceFeeAmount) {
		this.serviceFeeAmount = serviceFeeAmount;
	}
	public BigDecimal getGiftCardAmount() {
		return giftCardAmount;
	}
	public void setGiftCardAmount(BigDecimal giftCardAmount) {
		this.giftCardAmount = giftCardAmount;
	}
	public BigDecimal getNeedToPayAmount() {
		return needToPayAmount;
	}
	public void setNeedToPayAmount(BigDecimal needToPayAmount) {
		this.needToPayAmount = needToPayAmount;
	}
	public Integer getPaymentType() {
		return paymentType;
	}
	public void setPaymentType(Integer paymentType) {
		this.paymentType = paymentType;
	}
	public Integer getIsAnonymous() {
		return isAnonymous;
	}
	public void setIsAnonymous(Integer isAnonymous) {
		this.isAnonymous = isAnonymous;
	}
	public Integer getNeedInvoice() {
		return needInvoice;
	}
	public void setNeedInvoice(Integer needInvoice) {
		this.needInvoice = needInvoice;
	}
	public Integer getIsInvoiceInSamePackage() {
		return isInvoiceInSamePackage;
	}
	public void setIsInvoiceInSamePackage(Integer isInvoiceInSamePackage) {
		this.isInvoiceInSamePackage = isInvoiceInSamePackage;
	}
	public String getCouponCode() {
		return couponCode;
	}
	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}
	public BigDecimal getCouponDiscountAmount() {
		return couponDiscountAmount;
	}
	public void setCouponDiscountAmount(BigDecimal couponDiscountAmount) {
		this.couponDiscountAmount = couponDiscountAmount;
	}
	public String getGiftCardDesc() {
		return giftCardDesc;
	}
	public void setGiftCardDesc(String giftCardDesc) {
		this.giftCardDesc = giftCardDesc;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
	public String getInnerRemark() {
		return innerRemark;
	}
	public void setInnerRemark(String innerRemark) {
		this.innerRemark = innerRemark;
	}
	public String getFoodSpecific() {
		return foodSpecific;
	}
	public void setFoodSpecific(String foodSpecific) {
		this.foodSpecific = foodSpecific;
	}
	public Integer getIsForceAudit() {
		return isForceAudit;
	}
	public void setIsForceAudit(Integer isForceAudit) {
		this.isForceAudit = isForceAudit;
	}
	public Integer getIsDownload() {
		return isDownload;
	}
	public void setIsDownload(Integer isDownload) {
		this.isDownload = isDownload;
	}
	public String getSecondOrderSource() {
		return secondOrderSource;
	}
	public void setSecondOrderSource(String secondOrderSource) {
		this.secondOrderSource = secondOrderSource;
	}
	public Integer getHideFlag() {
		return hideFlag;
	}
	public void setHideFlag(Integer hideFlag) {
		this.hideFlag = hideFlag;
	}
	public String getBuyerNick() {
		return buyerNick;
	}
	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}
	public Float getCrossBorderFee() {
		return crossBorderFee;
	}
	public void setCrossBorderFee(Float crossBorderFee) {
		this.crossBorderFee = crossBorderFee;
	}
	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}
	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}
	public String getRefundStatus() {
		return refundStatus;
	}
	public void setRefundStatus(String refundStatus) {
		this.refundStatus = refundStatus;
	}
	public String getTradeNo() {
		return tradeNo;
	}
	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}
	public List<SoPackageVO> getSoPackageVOList() {
		return soPackageVOList;
	}
	public void setSoPackageVOList(List<SoPackageVO> soPackageVOList) {
		this.soPackageVOList = soPackageVOList;
	}
	public SoInvoiceInfo getSoInvoiceInfo() {
		return soInvoiceInfo;
	}
	public void setSoInvoiceInfo(SoInvoiceInfo soInvoiceInfo) {
		this.soInvoiceInfo = soInvoiceInfo;
	}
	public String getChannelName() {
		return channelName;
	}
	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}
	public Integer getChannelType() {
		return channelType;
	}
	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}
	public Boolean getCanCancleSku() {
		return canCancleSku;
	}
	public void setCanCancleSku(Boolean canCancleSku) {
		this.canCancleSku = canCancleSku;
	}

	/**
     * 订单类型
     *
     * @return
     */
    public String getSalesOrderTypeName() {

        return salesOrderType == null ? "" :
                salesOrderType.equals(SalesOrder.ORDER_TYPE_SALES) ? "渠道销售单" :
                        salesOrderType.equals(SalesOrder.ORDER_TYPE_EXCHANGE) ? "渠道换货单" :
                                salesOrderType.equals(SalesOrder.ORDER_TYPE_GROUP) ? "集团订单" :
                                        salesOrderType.equals(SalesOrder.ORDER_TYPE_GIFT) ? "礼品订单" :
                                                salesOrderType.equals(SalesOrder.ORDER_TYPE_SAMPLE) ? "样品订单" : "";
    }

    /**
     * 订单状态
     *
     * @return
     */
    public String getSalesOrderStatusName() {
        return SalesOrderVO.getSalesOrderStatusName(this.salesOrderStatus);
    }
    
    public static String getSalesOrderStatusName(Integer salesOrderStatus){
    	return salesOrderStatus == null ? "" :
            salesOrderStatus.equals(SalesOrder.ORDER_STATUS_CANCLE) ? "取消" :
                    salesOrderStatus.equals(SalesOrder.ORDER_STATUS_NONPAYMENT) ? "未付款" :
                            salesOrderStatus.equals(SalesOrder.ORDER_STATUS_HOLD) ? "未付款挂起" :
                                    salesOrderStatus.equals(SalesOrder.ORDER_STATUS_CHANGE_AFTER_RECEIVE) ? "换货待收货" :
                                            salesOrderStatus.equals(SalesOrder.ORDER_STATUS_HOLD_REVIEW) ? "审单挂起" :
                                                    salesOrderStatus.equals(SalesOrder.ORDER_STATUS_WAITING_REVIEW) ? "待审单" :
                                                            salesOrderStatus.equals(SalesOrder.ORDER_STATUS_ALREADY_REVIEW) ? "已审单" :
                                                                    salesOrderStatus.equals(SalesOrder.ORDER_STATUS_ALREADY_FINISHED) ? "已完成" : "";
    }

    /**
     * 支付方式
     *
     * @return
     */
    public String getPaymentTypeName() {
        return SalesOrderVO.getPaymentTypeName(this.paymentType);
    }

    public static String getPaymentTypeName(Integer paymentType){
    	return paymentType == null ? "" :
            paymentType.equals(SalesOrder.TYPE_CASH) ? "现金" :
                    paymentType.equals(SalesOrder.TYPE_DEBIT_CARD) ? "借记卡" :
                            paymentType.equals(SalesOrder.TYPE_CREDIT_CARD) ? "信用卡" :
                                    paymentType.equals(SalesOrder.TYPE_ALIPAY) ? "支付宝" :
                                            paymentType.equals(SalesOrder.TYPE_WEIXIN) ? "微信" :
                                                    paymentType.equals(SalesOrder.TYPE_CMB) ? "招行" :
                                                            paymentType.equals(SalesOrder.TYPE_TRANSFER) ? "转账" : "";
    }

    // 是否匿名
    public String getIsAnonymousName(){
    	 return isAnonymous == null ? "" :
    		 isAnonymous.equals(SalesOrder.IS_ANONYMOUS_TRUE) ? "是" :
    			 isAnonymous.equals(SalesOrder.IS_ANONYMOUS_FALSE) ? "否" : "";
    }

    // 折扣汇总（订单头折扣+订单行折扣汇总）
    /*public BigDecimal getDiscountAll(){
    	return this.getDiscountOnHead().add(this.getDiscountOnLine());
    }*/
}