package com.thebeastshop.scm.es;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.po.Campaign;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-07-15
 */
public class PsCampaignVO extends PsUpdateVO {

    private Long id;

    private String name;

    private String title;

    private Integer state;

    /**
     * 商品范围。1=单品；2=多品；3=全场
     */
    private Integer productScopeId;

    /**
     * 折扣类型。1=打折；2=满减；3=买赠；4=加价购
     */
    private Integer discountTypeId;

    /**
     * 是否海淘
     */
    private Integer crossBorderFlag;

    private String discountTypeName;

    private List<Integer> accessWayIds;

    private List<Integer> memberLevels;

    private Integer cumulative;

    private List<PsCampaignSectionVO> sections;

    private Date startTime;

    private Date expireTime;
    private Integer advance;                                    // 是否预告
    private String advanceStr;                                  // 是否预告文字：是、否
    private String advanceName;                                 // 预告名称
    private String advanceTitle;                                // 预告文案
    private Date advanceStartTime;                              // 预告开始时间
    private Date advanceEndTime;                                // 预告结束时间
    private String advancePriceTitle;                           // 预告价格文案
    private Integer factorType;                                 // 价格折扣活动折扣类型
    private Integer limitAmount;                                // 限购数量
    private String code;                                        // 活动编码
    private Integer active;                                     // 活动是否有效 1.有效 0.无效
    private Integer optionFlag;									// 任选对象:0.可以针对同一商品 1.不可针对同一商品
    private Integer isOverlap;									// 满赠多优惠区间是否叠加:0.否 1.是

    public PsCampaignVO() {
    }

    public PsCampaignVO(Campaign campaign) {
        id = campaign.getId().longValue();
        code = campaign.getCode();
        name = campaign.getName();
        title = campaign.getTitle();
        state = campaign.getState();
        productScopeId = campaign.getProductScope();
        discountTypeId = campaign.getDiscountType();
        DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.valueOf(discountTypeId);
        if (discountTypeEnum != null) {
            discountTypeName = discountTypeEnum.getName();
        }
        crossBorderFlag = campaign.getCrossBorderFlag();
        accessWayIds = splitIds(campaign.getAccessWay());
        memberLevels = splitIds(campaign.getMemberLevel());
        cumulative = campaign.getCumulative();
        startTime = campaign.getStartTime();
        expireTime = campaign.getExpireTime();
        advance = campaign.getIsAdvance();
        advanceName = campaign.getAdvanceName();
        advanceTitle = campaign.getAdvanceTitle();
        advanceStartTime = campaign.getAdvanceStartTime();
        advanceEndTime = campaign.getAdvanceEndTime();
        advancePriceTitle = campaign.getAdvancePriceTitle();
        factorType = campaign.getFactorType();
        limitAmount = campaign.getLimitAmount();
        active = campaign.getActive();
        optionFlag = campaign.getOptionFlag();
        isOverlap = campaign.getIsOverlap();
    }

    /**
     * 转换Campaign集合为VO集合
     * @param domains
     * @return
     */
    public static List<PsCampaignVO> transfer(List<Campaign> domains){
        List<PsCampaignVO> result = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(domains)) {
            PsCampaignVO vo;
            for (Campaign domain : domains) {
                vo = new PsCampaignVO(domain);
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashedMap();
        map.put("id", id);
        map.put("code", code);
        map.put("name", name);
        map.put("title", title);
        map.put("state", state);
        map.put("productScopeId", productScopeId);
        map.put("discountTypeId", discountTypeId);
        if (discountTypeName != null) {
            map.put("discountTypeName", discountTypeName);
        }
        map.put("crossBorderFlag", crossBorderFlag);
        map.put("accessWayIds", accessWayIds);
        map.put("memberLevels", memberLevels);
        map.put("cumulative", cumulative);
        map.put("startTime", startTime);
        map.put("expireTime", expireTime);
        map.put("advance", advance);
        map.put("advanceName", advanceName);
        map.put("advanceTitle", advanceTitle);
        map.put("advanceStartTime", advanceStartTime);
        map.put("advanceEndTime", advanceEndTime);
        map.put("advancePriceTitle", advancePriceTitle);
        map.put("factorType", factorType);
        map.put("limitAmount", limitAmount);
        map.put("optionFlag", optionFlag);
        map.put("isOverlap", isOverlap);
        map.put("active", active);
        if (sections != null) {
            List<Map> sectionMaps = new ArrayList<>();
            for (PsCampaignSectionVO sectionVO : sections) {
                sectionMaps.add(sectionVO.toMap());
            }
            map.put("campaignSections", sectionMaps);
        }
        return map;
    }

    private List<Integer> splitIds(String str) {
        List<Integer> ids = new ArrayList<>();
        if (StringUtils.isNoneBlank(str)) {
            String[] idArr = str.split(",");
            for (String id : idArr) {
                if (StringUtils.isNoneBlank(id)) {
                    try {
                        ids.add(Integer.valueOf(id));
                    } catch (Exception ex) {}
                }
            }
        }
        return ids;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getProductScopeId() {
        return productScopeId;
    }

    public void setProductScopeId(Integer productScopeId) {
        this.productScopeId = productScopeId;
    }

    public Integer getDiscountTypeId() {
        return discountTypeId;
    }

    public void setDiscountTypeId(Integer discountTypeId) {
        this.discountTypeId = discountTypeId;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public String getDiscountTypeName() {
        return discountTypeName;
    }

    public void setDiscountTypeName(String discountTypeName) {
        this.discountTypeName = discountTypeName;
    }

    public List<Integer> getAccessWayIds() {
        return accessWayIds;
    }

    public void setAccessWayIds(List<Integer> accessWayIds) {
        this.accessWayIds = accessWayIds;
    }

    public List<Integer> getMemberLevels() {
        return memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
    }

    public Integer getCumulative() {
        return cumulative;
    }

    public void setCumulative(Integer cumulative) {
        this.cumulative = cumulative;
    }

    public List<PsCampaignSectionVO> getSections() {
        return sections;
    }

    public void setSections(List<PsCampaignSectionVO> sections) {
        this.sections = sections;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getAdvance() {
        return advance;
    }

    public void setAdvance(Integer advance) {
        this.advance = advance;
    }

    public String getAdvanceStr() {
        return advanceStr;
    }

    public void setAdvanceStr(String advanceStr) {
        this.advanceStr = advanceStr;
    }

    public String getAdvanceName() {
        return advanceName;
    }

    public void setAdvanceName(String advanceName) {
        this.advanceName = advanceName;
    }

    public String getAdvanceTitle() {
        return advanceTitle;
    }

    public void setAdvanceTitle(String advanceTitle) {
        this.advanceTitle = advanceTitle;
    }

    public Date getAdvanceStartTime() {
        return advanceStartTime;
    }

    public void setAdvanceStartTime(Date advanceStartTime) {
        this.advanceStartTime = advanceStartTime;
    }

    public Date getAdvanceEndTime() {
        return advanceEndTime;
    }

    public void setAdvanceEndTime(Date advanceEndTime) {
        this.advanceEndTime = advanceEndTime;
    }

    public String getAdvancePriceTitle() {
        return advancePriceTitle;
    }

    public void setAdvancePriceTitle(String advancePriceTitle) {
        this.advancePriceTitle = advancePriceTitle;
    }

    public Integer getFactorType() {
        return factorType;
    }

    public void setFactorType(Integer factorType) {
        this.factorType = factorType;
    }

    public Integer getLimitAmount() {
        return limitAmount;
    }

    public void setLimitAmount(Integer limitAmount) {
        this.limitAmount = limitAmount;
    }

    public Integer getActive() {
        return active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

	public Integer getOptionFlag() {
		return optionFlag;
	}

	public void setOptionFlag(Integer optionFlag) {
		this.optionFlag = optionFlag;
	}

	public Integer getIsOverlap() {
		return isOverlap;
	}

	public void setIsOverlap(Integer isOverlap) {
		this.isOverlap = isOverlap;
	}
    
}
