package com.thebeastshop.scm.es;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;


public class PsSkuVO extends PsUpdateVO {
	private String id;
	private Long skuId;
    private String skuCode;
    private String skuName;
    private String skuNameCN;
    private Integer skuType;//SKU类型（创建后不可修改），1原材料2半成品3成品
    private Integer isMadeBySelf;//是否自产（创建后不可修改），0否1是
    private Integer isImported;//是否进口（创建后不可修改），0否1是
    
    private String skuCustomMadeCode;//定制SKU编码，null表示不是定制产品
    private Integer isSkuCustomMade;
    
    private String combinedSkuRecipeCode;//组合SKU配方，null表示不是配方产品
	private Integer isCombinedSkuRecipeCode;
    
	private Integer isJit;// 是否来单制作（高单价的组合配方SKU），0否1是
    private String ean13;
    private String barcode;//条形码
    private Integer canPurchase;//是否可采购，0否1是
	private Integer canCustomize; //是否可定制
    private BigDecimal costPrice;//成本价
    private Double salesPrice;//售价
	private BigDecimal customizationPrice; //定制费
	private List<PsSkuCustomizationVO> customizationList = new ArrayList<>(); //定制信息列表
	private PsCustomizeVO customize;
    private Long categoryId;//品类
    private String categoryName;//品类名
    private Long brandId; //品牌
    private String brandName;
    private String brandNameCN;
    private Long brandCountryId;
    private String brandCountryName;
    private String placeOfOrigin;//产地
    private Long supplierId;//供应商
    private String supplierName;
    private String supplierNameCN;
    private String skuCategoryName;//sku分类名
    private Integer canRemark;//是否可以备注
    private Integer pointDeductRule;//积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣
    private BigDecimal pointDeductPoint;//积分抵扣使用积分
    private BigDecimal pointDuductPrice;//积分抵扣后金额
    private Integer crossBorderFlag;//跨境购标注 0普通１跨境购
	private String weight;//净重
	private String taxNo;//税号
	private BigDecimal discountPrice;//折扣价
	private Integer whetherConsignment;
	private Integer clearanceWay;//通关方式（0：未知，1：BC，2：个人）

	private List<PcsSkuCategoryVO> frontCategoryList = new ArrayList<PcsSkuCategoryVO>();

	private Integer isMonthSend;

	private Integer monthSendDeliveryRule;

	private Integer deliveryTimes; //鲜花配送次数

	private Integer canCustomizeSalesPrice;

	/**
	 * 判断SKU是否可用
	 * @param chnCode
	 * @param canSaleSkuMap
	 * @param canSeeSkuMap
	 * @return
	 */
	public static boolean isAvaible(String chnCode,
									Map<String, String> canSaleSkuMap, Map<String, String> canSeeSkuMap,
									String skuCode) {
		return canSaleSkuMap.containsKey(skuCode) && canSeeSkuMap.containsKey(skuCode);
	}
    
    public PsSkuVO() {}

	public String getId() {return id;}
	public void setId(String id) {this.id = id;}

	public Long getSkuId() {
		return skuId;
	}

	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}

	public String getSkuNameCN() {
		return skuNameCN;
	}

	public void setSkuNameCN(String skuNameCN) {
		this.skuNameCN = skuNameCN;
	}

	public Integer getSkuType() {
		return skuType;
	}

	public void setSkuType(Integer skuType) {
		this.skuType = skuType;
	}

	public Integer getIsMadeBySelf() {
		return isMadeBySelf;
	}

	public void setIsMadeBySelf(Integer isMadeBySelf) {
		this.isMadeBySelf = isMadeBySelf;
	}

	public Integer getIsImported() {
		return isImported;
	}

	public void setIsImported(Integer isImported) {
		this.isImported = isImported;
	}

	public String getSkuCustomMadeCode() {
		return StringUtils.trimToEmpty(skuCustomMadeCode);
	}

	public void setSkuCustomMadeCode(String skuCustomMadeCode) {
		this.skuCustomMadeCode = skuCustomMadeCode;
		this.isSkuCustomMade = StringUtils.isBlank(skuCustomMadeCode) ? 0 : 1;
	}

	public Integer getIsSkuCustomMade() {
		return isSkuCustomMade;
	}

	public void setIsSkuCustomMade(Integer isSkuCustomMade) {
		this.isSkuCustomMade = isSkuCustomMade;
	}

	public String getCombinedSkuRecipeCode() {
		return StringUtils.trimToEmpty(combinedSkuRecipeCode);
	}

	public void setCombinedSkuRecipeCode(String combinedSkuRecipeCode) {
		this.combinedSkuRecipeCode = combinedSkuRecipeCode;
		this.isCombinedSkuRecipeCode = StringUtils.isBlank(combinedSkuRecipeCode) ? 0 :1;
	}

	public Integer getIsCombinedSkuRecipeCode() {
		return isCombinedSkuRecipeCode;
	}

	public void setIsCombinedSkuRecipeCode(Integer isCombinedSkuRecipeCode) {
		this.isCombinedSkuRecipeCode = isCombinedSkuRecipeCode;
	}

	public Integer getIsJit() {
		return isJit;
	}

	public void setIsJit(Integer isJit) {
		this.isJit = isJit;
	}

	public String getEan13() {
		return StringUtils.trimToEmpty(ean13);
	}

	public void setEan13(String ean13) {
		this.ean13 = ean13;
	}

	public String getBarcode() {
		return StringUtils.trimToEmpty(barcode);
	}

	public void setBarcode(String barcode) {
		this.barcode = barcode;
	}

	public Integer getCanPurchase() {
		return canPurchase;
	}

	public void setCanPurchase(Integer canPurchase) {
		this.canPurchase = canPurchase;
	}

	public BigDecimal getCostPrice() {
		return costPrice;
	}

	public void setCostPrice(BigDecimal costPrice) {
		this.costPrice = costPrice;
	}

	public Double getSalesPrice() {
		return salesPrice;
	}

	public void setSalesPrice(Double salesPrice) {
		this.salesPrice = salesPrice;
	}

	public Integer getCanCustomize() {
		return canCustomize;
	}

	public void setCanCustomize(Integer canCustomize) {
		this.canCustomize = canCustomize;
	}

	public BigDecimal getCustomizationPrice() {
		return customizationPrice;
	}

	public void setCustomizationPrice(BigDecimal customizationPrice) {
		this.customizationPrice = customizationPrice;
	}

	public List<PsSkuCustomizationVO> getCustomizationList() {
		return customizationList;
	}

	public void setCustomizationList(List<PsSkuCustomizationVO> customizationList) {
		this.customizationList = customizationList;
	}

	public PsCustomizeVO getCustomize() {
		return customize;
	}

	public void setCustomize(PsCustomizeVO customize) {
		this.customize = customize;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public Long getBrandId() {
		return brandId;
	}

	public void setBrandId(Long brandId) {
		this.brandId = brandId;
	}

	public String getBrandName() {
		return brandName;
	}

	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}

	public String getBrandNameCN() {
		return brandNameCN;
	}

	public void setBrandNameCN(String brandNameCN) {
		this.brandNameCN = brandNameCN;
	}

	public Long getBrandCountryId() {
		return brandCountryId;
	}

	public void setBrandCountryId(Long brandCountryId) {
		this.brandCountryId = brandCountryId;
	}

	public String getBrandCountryName() {
		return brandCountryName;
	}

	public void setBrandCountryName(String brandCountryName) {
		this.brandCountryName = brandCountryName;
	}

	public String getPlaceOfOrigin() {
		return StringUtils.trimToEmpty(placeOfOrigin);
	}

	public void setPlaceOfOrigin(String placeOfOrigin) {
		this.placeOfOrigin = placeOfOrigin;
	}

	public Long getSupplierId() {
		return supplierId;
	}

	public void setSupplierId(Long supplierId) {
		this.supplierId = supplierId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getSupplierNameCN() {
		return supplierNameCN;
	}

	public void setSupplierNameCN(String supplierNameCN) {
		this.supplierNameCN = supplierNameCN;
	}

	public String getSkuCategoryName() {
		return StringUtils.trimToEmpty(skuCategoryName);
	}

	public void setSkuCategoryName(String skuCategoryName) {
		this.skuCategoryName = skuCategoryName;
	}

	public Integer getCanRemark() {
		return canRemark;
	}

	public void setCanRemark(Integer canRemark) {
		this.canRemark = canRemark;
	}

	public Integer getPointDeductRule() {
		return pointDeductRule;
	}

	public void setPointDeductRule(Integer pointDeductRule) {
		this.pointDeductRule = pointDeductRule;
	}

	public BigDecimal getPointDeductPoint() {
		return pointDeductPoint;
	}

	public void setPointDeductPoint(BigDecimal pointDeductPoint) {
		this.pointDeductPoint = pointDeductPoint;
	}

	public BigDecimal getPointDuductPrice() {
		return pointDuductPrice;
	}

	public void setPointDuductPrice(BigDecimal pointDuductPrice) {
		this.pointDuductPrice = pointDuductPrice;
	}

	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	public String getWeight() {
		return weight;
	}

	public void setWeight(String weight) {
		this.weight = weight;
	}

	public String getTaxNo() {
		return taxNo;
	}

	public void setTaxNo(String taxNo) {
		this.taxNo = taxNo;
	}

	public BigDecimal getDiscountPrice() {
		return discountPrice;
	}

	public void setDiscountPrice(BigDecimal discountPrice) {
		this.discountPrice = discountPrice;
	}

	public Integer getClearanceWay() {
		return clearanceWay;
	}
	public Integer getWhetherConsignment() {
		if (this.whetherConsignment == null) {
			return 0;
		}
		return whetherConsignment;
	}
	public void setWhetherConsignment(Integer whetherConsignment) {
		this.whetherConsignment = whetherConsignment;
	}
	public void setClearanceWay(Integer clearanceWay) {
		this.clearanceWay = clearanceWay;
	}

	public List<PcsSkuCategoryVO> getFrontCategoryList() {
		return frontCategoryList;
	}

	public void setFrontCategoryList(List<PcsSkuCategoryVO> frontCategoryList) {
		this.frontCategoryList = frontCategoryList;
	}

	public Integer getIsMonthSend() {
		return isMonthSend;
	}

	public void setIsMonthSend(Integer isMonthSend) {
		this.isMonthSend = isMonthSend;
	}

	public Integer getMonthSendDeliveryRule() {
		return monthSendDeliveryRule;
	}

	public void setMonthSendDeliveryRule(Integer monthSendDeliveryRule) {
		this.monthSendDeliveryRule = monthSendDeliveryRule;
	}

	public Integer getDeliveryTimes() {
		return deliveryTimes;
	}

	public void setDeliveryTimes(Integer deliveryTimes) {
		this.deliveryTimes = deliveryTimes;
	}

	public Integer getCanCustomizeSalesPrice() {
		return canCustomizeSalesPrice;
	}

	public void setCanCustomizeSalesPrice(Integer canCustomizeSalesPrice) {
		this.canCustomizeSalesPrice = canCustomizeSalesPrice;
	}
}