package com.thebeastshop.scm.es;

import com.thebeastshop.scm.po.CustomizeElement;
import org.apache.commons.lang3.StringUtils;
import sun.swing.StringUIClientPropertyKey;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-12-16
 */
public class PsCustomizeElementVO extends PsBaseVO {

    private Long id;

    private Integer type;

    private String displayName;

    private String icon;

    private List<PsCustomizeChoiceVO> colors = new ArrayList<>();

    private Integer wordsLimit;

    private List<Integer> supportTypeIds;

    private Integer match;

    private Long parentId;

    public PsCustomizeElementVO(CustomizeElement customizeElement) {
        this.id = customizeElement.getId();
        this.type = customizeElement.getType();
        this.displayName = customizeElement.getDisplayName();
        this.icon = customizeElement.getIcon();
        String color = customizeElement.getColor();

        if (StringUtils.isNotBlank(color)) {
            String[] colorItems = color.split(";");
            if (colorItems.length > 0) {
                List<PsCustomizeChoiceVO> choiceList = new ArrayList<>();
                for (String item : colorItems) {
                    String[] itemNameVlaues = item.split(":");
                    if (itemNameVlaues.length < 2)
                        continue;
                    String name = itemNameVlaues[0];
                    String value = itemNameVlaues[1];
                    if (StringUtils.isBlank(name) || StringUtils.isBlank(value))
                        continue;
                    PsCustomizeChoiceVO choiceVO = new PsCustomizeChoiceVO();
                    choiceVO.setName(name);
                    choiceVO.setValue(value);
                    choiceList.add(choiceVO);
                }
                this.colors = choiceList;
            }
        }

        this.wordsLimit = customizeElement.getWordsLimit();
        String supportType = customizeElement.getSupportType();
        if (StringUtils.isNotBlank(supportType)) {
            String[] supportTypeIds = supportType.split(",");
            if (supportTypeIds.length > 0) {
                List<Integer> ids = new ArrayList<>();
                for (String idStr : supportTypeIds) {
                    if (StringUtils.isNotBlank(idStr)) {
                        try {
                            Integer id = Integer.parseInt(idStr);
                            ids.add(id);
                        } catch (Exception ex) {
                        }
                    }
                }
                this.supportTypeIds = ids;
            }
        }
        this.match = customizeElement.getMatch();
        this.parentId = customizeElement.getParentId();
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("type", type);
        map.put("icon", icon);
        if (colors != null) {
            List<Map<String, Object>> mapList = new ArrayList<>();
            for (PsCustomizeChoiceVO choiceVO : colors) {
                mapList.add(choiceVO.toMap());
            }
        }
        if (wordsLimit != null) {
            map.put("wordsLimit", wordsLimit);
        }
        if (supportTypeIds != null) {
            map.put("supportTypeIds", supportTypeIds);
        }
        map.put("match", match);
        map.put("parentId", parentId);
        return map;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<PsCustomizeChoiceVO> getColors() {
        return colors;
    }

    public void setColors(List<PsCustomizeChoiceVO> colors) {
        this.colors = colors;
    }

    public Integer getWordsLimit() {
        return wordsLimit;
    }

    public void setWordsLimit(Integer wordsLimit) {
        this.wordsLimit = wordsLimit;
    }

    public List<Integer> getSupportTypeIds() {
        return supportTypeIds;
    }

    public void setSupportTypeIds(List<Integer> supportTypeIds) {
        this.supportTypeIds = supportTypeIds;
    }

    public Integer getMatch() {
        return match;
    }

    public void setMatch(Integer match) {
        this.match = match;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
}
