/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.es;

import com.thebeastshop.scm.es.PsBaseVO;
import com.thebeastshop.scm.es.PsCustomizeChoiceVO;
import com.thebeastshop.scm.po.CustomizeElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PsCustomizeElementVO
extends PsBaseVO {
    private Long id;
    private Integer type;
    private String displayName;
    private String icon;
    private List<PsCustomizeChoiceVO> colors = new ArrayList<PsCustomizeChoiceVO>();
    private Integer wordsLimit;
    private List<Integer> supportTypeIds;
    private Integer match;
    private Long parentId;

    public PsCustomizeElementVO(CustomizeElement customizeElement) {
        String[] supportTypeIds;
        String[] colorItems;
        this.id = customizeElement.getId();
        this.type = customizeElement.getType();
        this.displayName = customizeElement.getDisplayName();
        this.icon = customizeElement.getIcon();
        String color = customizeElement.getColor();
        if (StringUtils.isNotBlank((CharSequence)color) && (colorItems = color.split(";")).length > 0) {
            ArrayList<PsCustomizeChoiceVO> choiceList = new ArrayList<PsCustomizeChoiceVO>();
            for (String item : colorItems) {
                String[] itemNameVlaues = item.split(":");
                if (itemNameVlaues.length < 2) continue;
                String name = itemNameVlaues[0];
                String value = itemNameVlaues[1];
                if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)value)) continue;
                PsCustomizeChoiceVO choiceVO = new PsCustomizeChoiceVO();
                choiceVO.setName(name);
                choiceVO.setValue(value);
                choiceList.add(choiceVO);
            }
            this.colors = choiceList;
        }
        this.wordsLimit = customizeElement.getWordsLimit();
        String supportType = customizeElement.getSupportType();
        if (StringUtils.isNotBlank((CharSequence)supportType) && (supportTypeIds = supportType.split(",")).length > 0) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (String idStr : supportTypeIds) {
                if (!StringUtils.isNotBlank((CharSequence)idStr)) continue;
                try {
                    Integer id = Integer.parseInt(idStr);
                    ids.add(id);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.supportTypeIds = ids;
        }
        this.match = customizeElement.getMatch();
        this.parentId = customizeElement.getParentId();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("type", this.type);
        map.put("icon", this.icon);
        if (this.colors != null) {
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            for (PsCustomizeChoiceVO choiceVO : this.colors) {
                mapList.add(choiceVO.toMap());
            }
        }
        if (this.wordsLimit != null) {
            map.put("wordsLimit", this.wordsLimit);
        }
        if (this.supportTypeIds != null) {
            map.put("supportTypeIds", this.supportTypeIds);
        }
        map.put("match", this.match);
        map.put("parentId", this.parentId);
        return map;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<PsCustomizeChoiceVO> getColors() {
        return this.colors;
    }

    public void setColors(List<PsCustomizeChoiceVO> colors) {
        this.colors = colors;
    }

    public Integer getWordsLimit() {
        return this.wordsLimit;
    }

    public void setWordsLimit(Integer wordsLimit) {
        this.wordsLimit = wordsLimit;
    }

    public List<Integer> getSupportTypeIds() {
        return this.supportTypeIds;
    }

    public void setSupportTypeIds(List<Integer> supportTypeIds) {
        this.supportTypeIds = supportTypeIds;
    }

    public Integer getMatch() {
        return this.match;
    }

    public void setMatch(Integer match) {
        this.match = match;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
}

