package com.thebeastshop.scm.vo.interest;

import java.util.Date;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.Interest;
import com.thebeastshop.scm.po.InterestSku;

/**
 * 获取权益接口VO 
 * @author donghui
 */
public class InterestGetVO extends AbstractDomain {
	private Integer interestId;
	private Integer isFreePost;//是否包邮
	private Date cashStartTime;//兑换开始时间
	private Date cashEndTime;//兑换结束时间
	private Integer interestSkuId;//默认的权益sku表id
	private String skuCode;//默认的权益sku code
	private String skuNameCn;//默认的权益sku中文名
	
	private ExceptionEnum exceptionEnum;

	public InterestGetVO() {}
	
	public InterestGetVO(ExceptionEnum exceptionEnum) {
		this.exceptionEnum = exceptionEnum;
	}
	public InterestGetVO(Interest interest, InterestSku interestSku) {
		this.interestId = interest.getId();
		this.isFreePost = interest.getIsFreePost();
		this.cashStartTime = interest.getCashStartTime();
		this.cashEndTime = interest.getCashEndTime();
		
		this.interestSkuId = interestSku.getId();
		this.skuCode = interestSku.getSkuCode();
		this.skuNameCn = interestSku.getSkuNameCn();
	}
	
	public enum ExceptionEnum {
		INTEREST_NOT_FOUND,//没有找到正在开始的权益记录
		NOT_STOCK,//没有库存
		OPTIMISTIC_LOCK_UPDATE_FAILURE,//乐观锁更新失败
	}
	public Integer getInterestId() {
		return interestId;
	}
	public void setInterestId(Integer interestId) {
		this.interestId = interestId;
	}
	public Integer getIsFreePost() {
		return isFreePost;
	}
	public void setIsFreePost(Integer isFreePost) {
		this.isFreePost = isFreePost;
	}
	public Date getCashStartTime() {
		return cashStartTime;
	}
	public void setCashStartTime(Date cashStartTime) {
		this.cashStartTime = cashStartTime;
	}
	public Date getCashEndTime() {
		return cashEndTime;
	}
	public void setCashEndTime(Date cashEndTime) {
		this.cashEndTime = cashEndTime;
	}
	public Integer getInterestSkuId() {
		return interestSkuId;
	}
	public void setInterestSkuId(Integer interestSkuId) {
		this.interestSkuId = interestSkuId;
	}
	public String getSkuCode() {
		return skuCode;
	}
	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}
	public String getSkuNameCn() {
		return skuNameCn;
	}
	public void setSkuNameCn(String skuNameCn) {
		this.skuNameCn = skuNameCn;
	}
	public ExceptionEnum getExceptionEnum() {
		return exceptionEnum;
	}
	public void setExceptionEnum(ExceptionEnum exceptionEnum) {
		this.exceptionEnum = exceptionEnum;
	}

}
