package com.thebeastshop.scm.vo.interest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import pers.richard.ormybatis.domain.core.AbstractDomain;
import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.scm.po.Interest;
import com.thebeastshop.scm.po.InterestSku;

/**
 * 编辑商品领用权益保存VO 
 * @author donghui
 */
public class InterestSaveVO extends AbstractDomain {
	private Integer id;
	private String prodCode;
	private Integer isFreePost;
	private Date receiptStartTime;
	private Date receiptEndTime;
	private Date cashStartTime;
	private Date cashEndTime;
	private List<Integer> interestSkuId = new ArrayList<>();
	private List<String> skuCode = new ArrayList<>();
	private List<String> skuNameCn = new ArrayList<>();
	private List<Integer> quantity = new ArrayList<>();//sku可领取数量
	
	public InterestSaveVO(){}
	
	public Interest toInterest(){
		Interest interest = new Interest();
		interest.setId(this.id);
		interest.setProdCode(this.prodCode);
		interest.setIsFreePost(this.isFreePost);
		interest.setReceiptStartTime(this.receiptStartTime);
		interest.setReceiptEndTime(this.receiptEndTime);
		interest.setCashStartTime(this.cashStartTime);
		interest.setCashEndTime(this.cashEndTime);
		if (this.id == null) {
			interest.setCreateTime(new Date());
		}
		interest.setUpdateTime(new Date());
		return interest;
	}
	
	public List<InterestSku> toInterestSku(Integer interestId){
		List<InterestSku> result = new ArrayList<InterestSku>();
		for (int i = 0; i < skuCode.size(); i++) {
			String code = skuCode.get(i);
			InterestSku interestSku = new InterestSku();
			interestSku.setId(ObjUtils.get(interestSkuId, i));
			interestSku.setInterestId(interestId);
			interestSku.setSkuCode(code);
			interestSku.setSkuNameCn(ObjUtils.get(skuNameCn, i));
			interestSku.setUpdateTime(new Date());
			interestSku.setQuantity(ObjUtils.get(quantity, i));
			if (interestSku.getId() == null) {
				interestSku.setReceiveQuantity(0);
				interestSku.setCreateTime(new Date());
			}
			result.add(interestSku);
		}
		return result;
	}
	

	public Integer getId() {
		return id;
	}
	public void setId(Integer id) {
		this.id = id;
	}
	public String getProdCode() {
		return prodCode;
	}
	public void setProdCode(String prodCode) {
		this.prodCode = prodCode;
	}
	public Integer getIsFreePost() {
		return isFreePost;
	}
	public void setIsFreePost(Integer isFreePost) {
		this.isFreePost = isFreePost;
	}
	public Date getReceiptStartTime() {
		return receiptStartTime;
	}
	public void setReceiptStartTime(Date receiptStartTime) {
		this.receiptStartTime = receiptStartTime;
	}
	public Date getReceiptEndTime() {
		return receiptEndTime;
	}
	public void setReceiptEndTime(Date receiptEndTime) {
		this.receiptEndTime = receiptEndTime;
	}
	public Date getCashStartTime() {
		return cashStartTime;
	}
	public void setCashStartTime(Date cashStartTime) {
		this.cashStartTime = cashStartTime;
	}
	public Date getCashEndTime() {
		return cashEndTime;
	}
	public void setCashEndTime(Date cashEndTime) {
		this.cashEndTime = cashEndTime;
	}
	public List<String> getSkuCode() {
		return skuCode;
	}
	public void setSkuCode(List<String> skuCode) {
		this.skuCode = skuCode;
	}
	public List<Integer> getQuantity() {
		return quantity;
	}
	public void setQuantity(List<Integer> quantity) {
		this.quantity = quantity;
	}
	public List<Integer> getInterestSkuId() {
		return interestSkuId;
	}
	public void setInterestSkuId(List<Integer> interestSkuId) {
		this.interestSkuId = interestSkuId;
	}
	public List<String> getSkuNameCn() {
		return skuNameCn;
	}
	public void setSkuNameCn(List<String> skuNameCn) {
		this.skuNameCn = skuNameCn;
	}
}
