package com.thebeastshop.scm.vo.recommend;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import pers.richard.ormybatis.domain.core.AbstractDomain;
import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.scm.po.RecommendProductAuto;


public class RecommendAutoProdSaveVO extends AbstractDomain {
	private String position;//位置ADD_ON_ITEM("免邮凑单推荐"), PROD_DETAIL("商品详细推荐");
	private String sourceProductCode;//当选择商品详情推荐时
	
	private List<Integer> id = new ArrayList<>();//recommend_product_auto表id
	private List<String> recommendProductCode = new ArrayList<>();
	private List<String> type = new ArrayList<>();
	private List<Integer> sort = new ArrayList<>();
	private List<Integer> status = new ArrayList<>();
	
	public RecommendAutoProdSaveVO(){
	}
	
	public List<RecommendProductAuto> toRecommendAutoProdList(){
		List<RecommendProductAuto> list = new ArrayList<RecommendProductAuto>();
		for (int i = 0; i < recommendProductCode.size(); i++) {
			RecommendProductAuto recommendProductAuto = new RecommendProductAuto();
			recommendProductAuto.setId(ObjUtils.get(id, i));
			recommendProductAuto.setSourceProductCode(sourceProductCode);
			recommendProductAuto.setPosition(position);
			Integer sortInt = ObjUtils.get(sort, i);
			Integer statusInt = ObjUtils.get(status, i);
			if (recommendProductAuto.getId() == 0 && sortInt == null && statusInt == 1) {
				continue;
			}
			recommendProductAuto.setSort(sortInt);
			recommendProductAuto.setRecommendProductCode(ObjUtils.get(recommendProductCode, i));
			if (recommendProductAuto.getId() == null || recommendProductAuto.getId() == 0 ) {
				recommendProductAuto.setCreateTime(new Date());
			}
			recommendProductAuto.setStatus(statusInt);
			recommendProductAuto.setType(ObjUtils.get(type, i));
			recommendProductAuto.setUpdateTime(new Date());
			list.add(recommendProductAuto);
		}
		return list;
	}
	
	public List<Integer> getStatus() {
		return status;
	}

	public void setStatus(List<Integer> status) {
		this.status = status;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public String getSourceProductCode() {
		return sourceProductCode;
	}

	public void setSourceProductCode(String sourceProductCode) {
		this.sourceProductCode = sourceProductCode;
	}

	public List<Integer> getId() {
		return id;
	}

	public void setId(List<Integer> id) {
		this.id = id;
	}

	public List<String> getRecommendProductCode() {
		return recommendProductCode;
	}

	public void setRecommendProductCode(List<String> recommendProductCode) {
		this.recommendProductCode = recommendProductCode;
	}

	public List<String> getType() {
		return type;
	}

	public void setType(List<String> type) {
		this.type = type;
	}

	public List<Integer> getSort() {
		return sort;
	}

	public void setSort(List<Integer> sort) {
		this.sort = sort;
	}
	
}