package com.thebeastshop.scm.es;

import java.math.BigDecimal;
import java.util.*;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class PsProductVO extends PsUpdateVO {
	
	private String id;
	private String code;
	private Integer combined;
    private BigDecimal listPrice;//列表价
    private String listPriceSkuCode; //列表价对应的SKU
    private Integer listPriceSpvId; //列表价对应的SPV
    private LinkedHashMap<String, Map> listPriceList; //多渠道列表价
    private Integer allowVipDiscount;//是否支持VIP折扣，1是0否
    private Integer allowNoteCard;//是否支持代写卡片，0否1是
    private Integer prepareDays;// 备货天数，默认0
    private Integer selectDeliveryDays;//可选择配送日期天数，0:尽快（不可选），n:n天内(默认n=7)
    private String picList;//图片（列表）
    private String picDetail;//图片（详情）
    private String picThumb;//图片（缩略）
    private String picDetailMul;//图片,手机端,多张以’，‘ 分割
    private Integer expressType;// 快递类型，1店送2联邦3顺丰
    private String name;//产品名
    private String nameCn;// 产品中文名
    private String skuCategoryDesc;//SKU分类描述PsProductVO
    private Long categoryId;//prod category , last update sku's category
    private String categoryCode;//prod category , last update sku's category
    private List<PsCampaignVO> campaignList = new ArrayList<>(); // 促销活动
    private Integer seq;
    private Integer sort1;
    private Integer sort2;
	private String description;//一句话描述
	private Date saleStartDate;//开始销售时间
	private Integer crossBorderFlag;//Sku的跨境购标注 0普通１跨境购

    private Map<String, String> canSaleSkuMap;
    private Map<String, String> canSeeSkuMap;
	
	private List<String> skuCodes = new ArrayList<>();
	private List<String> smallIconList  = new ArrayList<String>();
	private List<String> largeIconList = new ArrayList<String>();
	private List<String> chnSaleChnCodes = new ArrayList<>();//所有渠道编码
	private List<String> onShelfChnCodes = new ArrayList<>();//上架渠道编码
	private List<String> offShelfChnCodes = new ArrayList<>();//下架渠道编码
	
	/** keys:{ categoryId,categoryCode,categoryName,categoryFullName,sort1,sort2} */
    private List<Map> frontCategories = new ArrayList<>();

    /** keys:{string:chnCode; int:stock; int:soldOut} */
    private List<Map> stocks = new ArrayList<>();
    private List<PsTagVO> psTags = new ArrayList<>();
    private List<PsDeliveryVO> selfDeliveries = new ArrayList<PsDeliveryVO>();//配送信息 区县  (自送)
    private List<PsDynmContentVO> dynmContents = new ArrayList<>();
    private List<PsChnProdSaleSku> chnCanSaleSKu = new ArrayList<>();//渠道Prod可售sku
    private List<PsChnProdSaleSku> chnCanSeeSKu = new ArrayList<>();//渠道Prod 可见 sku

	/**
     *  Map keys:{ brandId,brandNameCN,brandName,brandCountryId,brandCountryName }
     */
	private List<Map> brandList = new ArrayList<>();//所有sku下的品牌
	private List<PsChnProdTimeCodeInfo> channelProdInfo = new ArrayList<>();// 产品渠道绑定时间
	private List<Map> labels = new ArrayList<>();//标签
	private List<PsAttributeVO> attributeList = new ArrayList<PsAttributeVO>();//属性
	private List<PsSpvVO>spvList = new ArrayList<PsSpvVO>();//

    private String primaryUpdateTime;
    private Long primaryUpdateLong;


    /**
     * 获取所有可用SPV
     * @param chnCode
     * @param psProductVO
     * @return
     */
    public static List<PsSpvVO> getAvaiableSpvs(String chnCode, PsProductVO psProductVO) {
        List<PsSpvVO> list = new ArrayList<>();
        Map<String, String> canSaleSkuMap = getCanSaleSkuMap(chnCode, psProductVO);
        Map<String, String> canSeeSkuMap = getCanSeeSkuMap(chnCode, psProductVO);
        List<PsSpvVO> spvVOs = psProductVO.getSpvList();
        if (CollectionUtils.isEmpty(spvVOs)) {
            return Lists.newArrayList();
        }
        for (PsSpvVO spvVO : spvVOs) {
            if (PsSpvVO.isAvaible(chnCode, true, canSaleSkuMap, canSeeSkuMap, spvVO)) {
                list.add(spvVO);
            }
        }
        return list;
    }


    /**
     * 获取所有可用SPV的ID
     * @param chnCode
     * @param psProductVO
     * @return
     */
    public static List<Integer> getAvaiableSpvIds(String chnCode, PsProductVO psProductVO) {
        List<Integer> ids = new ArrayList<>();
        List<PsSpvVO> spvVOs = getAvaiableSpvs(chnCode, psProductVO);
        for (PsSpvVO psSpvVO : spvVOs) {
            ids.add(psSpvVO.getSpvId());
        }
        return ids;
    }


    public static Map<String, String> getCanSeeSkuMap(String chnCode, PsProductVO psProductVO) {
        if (psProductVO.canSeeSkuMap != null) return psProductVO.canSeeSkuMap;
        Map<String, String> canSeeSkuMap = new HashedMap();
        List<PsChnProdSaleSku> canSeeSkuList = psProductVO.getChnCanSeeSKu();
        if (CollectionUtils.isEmpty(canSeeSkuList)) return canSeeSkuMap;
        PsChnProdSaleSku canSeeSku = null;
        for (PsChnProdSaleSku chnProdSaleSkuVO : canSeeSkuList) {
            if (StringUtils.equals(chnProdSaleSkuVO.getChnCode(), chnCode)) {
                canSeeSku = chnProdSaleSkuVO;
                break;
            }
        }
        if (canSeeSku != null) {
            for (String skuCode : canSeeSku.getCanSkus()) {
                canSeeSkuMap.put(skuCode, skuCode);
            }
        }
        psProductVO.canSeeSkuMap = canSeeSkuMap;
        return canSeeSkuMap;
    }

    public static Map<String, String> getCanSaleSkuMap(String chnCode, PsProductVO psProductVO) {
        if (psProductVO.canSaleSkuMap != null) return psProductVO.canSaleSkuMap;
        Map<String, String> canSaleSkuMap = new HashedMap();
        List<PsChnProdSaleSku> canSaleSkuList = psProductVO.getChnCanSaleSKu();
        if (CollectionUtils.isEmpty(canSaleSkuList)) return canSaleSkuMap;
        PsChnProdSaleSku canSaleSku = null;
        for (PsChnProdSaleSku chnProdSaleSkuVO : canSaleSkuList) {
            if (StringUtils.equals(chnProdSaleSkuVO.getChnCode(), chnCode)) {
                canSaleSku = chnProdSaleSkuVO;
                break;
            }
        }
        if (canSaleSku != null) {
            for (String skuCode : canSaleSku.getCanSkus()) {
                canSaleSkuMap.put(skuCode, skuCode);
            }
        }
        psProductVO.canSaleSkuMap = canSaleSkuMap;
        return canSaleSkuMap;
    }


    public PsProductVO() {}
	
	public List<String> getPicDetailMuls(){
        if (StringUtils.isBlank(picDetailMul)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(picDetailMul.split(","));
    }

    public void addIcon(String smallIcon, String largeIcon) {
		if (StringUtils.isNotBlank(smallIcon)) {
			this.smallIconList.add(smallIcon);
		}
		if (StringUtils.isNotBlank(largeIcon)) {
			this.largeIconList.add(largeIcon);
		}
	}
	
    
	public Integer getSeq() {
		if (this.seq == null) {
			return 9999;
		}
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Integer getSort1() {
		if (this.sort1 == null) {
			return 99999;
		}
        return sort1;
    }

    public void setSort1(Integer sort1) {
        this.sort1 = sort1;
    }

    public Integer getSort2() {
    	if (this.sort2 == null) {
			return 99999;
		}
        return sort2;
    }

    public void setSort2(Integer sort2) {
        this.sort2 = sort2;
    }

    public Integer getExpressType() {
    	if (this.expressType == null) {
			return 3;
		}
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public Long getCategoryId() {
    	if (this.categoryId == null) {
			return 0L;
		}
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryCode() {
        return StringUtils.trimToEmpty(categoryCode);
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public List<Map> getFrontCategories() {
        return frontCategories;
    }

    public void setFrontCategories(List<Map> frontCategories) {
    	if (frontCategories == null) {return;}
        this.frontCategories = frontCategories;
    }


    public List<PsCampaignVO> getCampaignList() {
        return campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }

    public List<Map> getStocks() {
        return stocks;
    }

    public void setStocks(List<Map> stocks) {
        this.stocks = stocks;
    }
	
	public List<String> getSmallIconList() {
		return smallIconList;
	}

	public void setSmallIconList(List<String> smallIconList) {
		if (smallIconList == null) {return;}
		this.smallIconList = smallIconList;
	}

	public List<String> getLargeIconList() {
		return largeIconList;
	}

	public void setLargeIconList(List<String> largeIconList) {
		if (largeIconList == null) {return;}
		this.largeIconList = largeIconList;
	}

	public List<PsTagVO> getPsTags() {
		return psTags;
	}

	public void setPsTags(List<PsTagVO> psTags) {
		if (psTags == null) {return;}
		this.psTags = psTags;
	}

	public List<PsDeliveryVO> getSelfDeliveries() {
        return selfDeliveries;
    }

    public void setSelfDeliveries(List<PsDeliveryVO> selfDeliveries) {
    	if (selfDeliveries == null) {return;}
        this.selfDeliveries = selfDeliveries;
    }

    public List<PsChnProdSaleSku> getChnCanSaleSKu() {
        return chnCanSaleSKu;
    }

    public void setChnCanSaleSKu(List<PsChnProdSaleSku> chnCanSaleSKu) {
    	if (chnCanSaleSKu == null) {return;}
        this.chnCanSaleSKu = chnCanSaleSKu;
    }

    public List<String> getChnSaleChnCodes() {
        return chnSaleChnCodes;
    }

    public void setChnSaleChnCodes(List<String> chnSaleChnCodes) {
    	if (chnSaleChnCodes == null) {return;}
        this.chnSaleChnCodes = chnSaleChnCodes;
    }

    public List<String> getOnShelfChnCodes() {
        return onShelfChnCodes;
    }

    public void setOnShelfChnCodes(List<String> onShelfChnCodes) {
    	if (onShelfChnCodes == null) {return;}
        this.onShelfChnCodes = onShelfChnCodes;
    }

    public List<String> getOffShelfChnCodes() {
        return offShelfChnCodes;
    }

    public void setOffShelfChnCodes(List<String> offShelfChnCodes) {
    	if (offShelfChnCodes == null) {return;}
        this.offShelfChnCodes = offShelfChnCodes;
    }

    public List<PsDynmContentVO> getDynmContents() {
        return dynmContents;
    }

    public void setDynmContents(List<PsDynmContentVO> dynmContents) {
    	if (dynmContents == null) {return;}
        this.dynmContents = dynmContents;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return listPrice;
    }

    public void setListPrice(BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public String getListPriceSkuCode() {
        return listPriceSkuCode;
    }

    public void setListPriceSkuCode(String listPriceSkuCode) {
        this.listPriceSkuCode = listPriceSkuCode;
    }

    public Integer getListPriceSpvId() {
        return listPriceSpvId;
    }

    public void setListPriceSpvId(Integer listPriceSpvId) {
        this.listPriceSpvId = listPriceSpvId;
    }

    public LinkedHashMap<String, Map> getListPriceMapList() {
        return listPriceList;
    }

    public void setListPriceMapList(LinkedHashMap<String, Map> listPriceList) {
        this.listPriceList = listPriceList;
    }

    public List<Map> getListPriceList() {
        List<Map> list = new ArrayList<>();
        if (MapUtils.isNotEmpty(listPriceList)) {
            for (String key : listPriceList.keySet()) {
                Map map = listPriceList.get(key);
                list.add(map);
            }
        }
        return list;
    }

    public Integer getAllowVipDiscount() {
        return allowVipDiscount;
    }

    public void setAllowVipDiscount(Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return allowNoteCard;
    }

    public void setAllowNoteCard(Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }

    public Integer getPrepareDays() {
        return prepareDays;
    }

    public void setPrepareDays(Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return selectDeliveryDays;
    }

    public void setSelectDeliveryDays(Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

    public String getPicList() {
        return picList == null?"":picList;
    }

    public void setPicList(String picList) {
        this.picList = picList;
    }

    public String getPicDetail() {
        return picDetail == null?"":picDetail;
    }

    public void setPicDetail(String picDetail) {
        this.picDetail = picDetail;
    }

    public String getPicThumb() {
        return picThumb == null?"":picThumb;
    }

    public void setPicThumb(String picThumb) {
        this.picThumb = picThumb;
    }

    public String getName() {
        return StringUtils.trimToEmpty(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn == null?"":nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
    	if (skuCodes == null) {return;}
        this.skuCodes = skuCodes;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSkuCategoryDesc() {
        return skuCategoryDesc;
    }

    public void setSkuCategoryDesc(String skuCategoryDesc) {
        this.skuCategoryDesc = skuCategoryDesc;
    }

    public List<PsChnProdSaleSku> getChnCanSeeSKu() {
        return chnCanSeeSKu;
    }

    public void setChnCanSeeSKu(List<PsChnProdSaleSku> chnCanSeeSKu) {
    	if (chnCanSeeSKu == null) {
			return;
		}
        this.chnCanSeeSKu = chnCanSeeSKu;
    }

    public Date getSaleStartDate() {
        return saleStartDate;
    }

    public void setSaleStartDate(Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public String getPicDetailMul() {
        return StringUtils.trimToEmpty(picDetailMul);
    }

    public void setPicDetailMul(String picDetailMul) {
        this.picDetailMul = picDetailMul;
    }
    
    public String getDescription() {
		return StringUtils.trimToEmpty(description);
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
    public List<Map> getBrandList() {
		return brandList;
	}
	public void setBrandList(List<Map> brandList) {
		this.brandList = brandList;
	}
	public List<PsChnProdTimeCodeInfo> getChannelProdInfo() {
		return channelProdInfo;
	}

	public void setChannelProdInfo(List<PsChnProdTimeCodeInfo> channelProdInfo) {
		this.channelProdInfo = channelProdInfo;
	}
	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}
    public List<Map> getLabels() {
		return labels;
	}
	public void setLabels(List<Map> labels) {
		this.labels = labels;
	}
	public List<PsAttributeVO> getAttributeList() {
		return attributeList;
	}
	public void setAttributeList(List<PsAttributeVO> attributeList) {
		this.attributeList = attributeList;
	}
	public List<PsSpvVO> getSpvList() {
		return spvList;
	}
	public void setSpvList(List<PsSpvVO> spvList) {
		this.spvList = spvList;
	}
    public Integer getCombined() {
		return combined;
	}
	public void setCombined(Integer combined) {
		this.combined = combined;
	}
    public String getPrimaryUpdateTime() {
        return primaryUpdateTime;
    }
    public void setPrimaryUpdateTime(String primaryUpdateTime) {
        this.primaryUpdateTime = primaryUpdateTime;
    }
    public Long getPrimaryUpdateLong() {
        return primaryUpdateLong;
    }
    public void setPrimaryUpdateLong(Long primaryUpdateLong) {
        this.primaryUpdateLong = primaryUpdateLong;
    }
}
