package com.thebeastshop.scm.vo.lottery;

import pers.richard.ormybatis.domain.core.AbstractDomain;

/**
 * 抽奖中奖信息VO
 * @author donghui
 */
public class LotteryActivityDrawResultVO extends AbstractDomain {
	private DrawResultException drawResultException;//校验抽奖规则错误枚举(为null表示没有错误)
	private LotteryActivityRecordVO lotteryActivityRecordVO;//中奖信息
	
	private LotteryActivityDrawResultVO() {}
	
	
	/** LotteryActivityDrawResultVO
	 * 抽奖的结果
	 */
	public static LotteryActivityDrawResultVO newInstanceSuccess(LotteryActivityRecordVO recordVO) {
		LotteryActivityDrawResultVO vo = new LotteryActivityDrawResultVO();
		vo.setLotteryActivityRecordVO(recordVO);
		return vo;
	} 
	
	/**
	 * 抽奖资格失败的结果
	 */
	public static LotteryActivityDrawResultVO newInstanceFail(DrawResultException drawResultException) {
		LotteryActivityDrawResultVO vo = new LotteryActivityDrawResultVO();
		vo.setDrawResultException(drawResultException);
		return vo;
	} 
	

	public LotteryActivityRecordVO getLotteryActivityRecordVO() {
		return lotteryActivityRecordVO;
	}

	public void setLotteryActivityRecordVO(LotteryActivityRecordVO lotteryActivityRecordVO) {
		this.lotteryActivityRecordVO = lotteryActivityRecordVO;
	}
	
	public DrawResultException getDrawResultException() {
		return drawResultException;
	}

	public void setDrawResultException(DrawResultException drawResultException) {
		this.drawResultException = drawResultException;
	}
}
