package com.thebeastshop.scm.vo.lottery;

import pers.richard.ormybatis.domain.core.AbstractDomain;

/**
 * 抽奖中奖信息VO
 * @author donghui
 */
public class LotteryActivityDrawParamVO extends AbstractDomain {
	private DrawResultException drawResultException;//校验抽奖规则错误枚举(为null表示没有错误)
	private LotteryActivityRecordVO lotteryActivityRecordVO;//中奖信息
	
	private LotteryActivityDrawParamVO() {}
	
	
	/** LotteryActivityDrawResultVO
	 * 抽奖的结果
	 */
	public static LotteryActivityDrawParamVO newInstanceSuccess(LotteryActivityRecordVO recordVO) {
		LotteryActivityDrawParamVO vo = new LotteryActivityDrawParamVO();
		vo.setLotteryActivityRecordVO(recordVO);
		return vo;
	} 
	
	/**
	 * 抽奖资格失败的结果
	 */
	public static LotteryActivityDrawParamVO newInstanceFail(DrawResultException drawResultException) {
		LotteryActivityDrawParamVO vo = new LotteryActivityDrawParamVO();
		vo.setDrawResultException(drawResultException);
		return vo;
	} 
	

	public LotteryActivityRecordVO getLotteryActivityRecordVO() {
		return lotteryActivityRecordVO;
	}

	public void setLotteryActivityRecordVO(LotteryActivityRecordVO lotteryActivityRecordVO) {
		this.lotteryActivityRecordVO = lotteryActivityRecordVO;
	}
	
	public DrawResultException getDrawResultException() {
		return drawResultException;
	}

	public void setDrawResultException(DrawResultException drawResultException) {
		this.drawResultException = drawResultException;
	}
}
