package com.thebeastshop.scm.vo.lottery;

import pers.richard.ormybatis.domain.core.AbstractDomain;

/**
 * 抽奖中奖信息VO
 * @author donghui
 */
public class LotteryActivityDrawResultVO extends AbstractDomain {
	private Boolean isCheck;//抽奖检验是否通过
	private String failReason;//检验失败原因
	private LotteryActivityRecordVO lotteryActivityRecordVO;//中奖信息
	
	private LotteryActivityDrawResultVO() {}
	
	/**
	 * 抽奖的结果
	 */
	public static LotteryActivityDrawResultVO newInstanceSuccess(LotteryActivityRecordVO recordVO) {
		LotteryActivityDrawResultVO vo = new LotteryActivityDrawResultVO();
		vo.setIsCheck(true);
		vo.setLotteryActivityRecordVO(recordVO);
		return vo;
	} 
	
	/**
	 * 抽奖资格失败的结果
	 */
	public static LotteryActivityDrawResultVO newInstanceFail(String failReason) {
		LotteryActivityDrawResultVO vo = new LotteryActivityDrawResultVO();
		vo.setIsCheck(false);
		vo.setFailReason(failReason);
		return vo;
	} 
	
	public Boolean getIsCheck() {
		return isCheck;
	}

	public void setIsCheck(Boolean isCheck) {
		this.isCheck = isCheck;
	}

	public String getFailReason() {
		return failReason;
	}

	public void setFailReason(String failReason) {
		this.failReason = failReason;
	}

	public LotteryActivityRecordVO getLotteryActivityRecordVO() {
		return lotteryActivityRecordVO;
	}

	public void setLotteryActivityRecordVO(
			LotteryActivityRecordVO lotteryActivityRecordVO) {
		this.lotteryActivityRecordVO = lotteryActivityRecordVO;
	}
	
}
