/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.es;

import com.thebeastshop.scm.es.PsBaseVO;
import com.thebeastshop.scm.es.PsCampaignSectionProductVO;
import com.thebeastshop.scm.po.CampaignSection;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;

public class PsCampaignSectionVO
extends PsBaseVO {
    private Long id;
    private Long campaignId;
    private Integer conditionType;
    private BigDecimal line;
    private BigDecimal factor;
    private Integer factorType;
    private Double ranking;
    private List<PsCampaignSectionProductVO> campaignSectionProducts;

    public PsCampaignSectionVO() {
    }

    public PsCampaignSectionVO(CampaignSection campaignSection) {
        this.id = campaignSection.getId().longValue();
        this.campaignId = campaignSection.getCampaignId();
        this.conditionType = campaignSection.getType();
        this.line = campaignSection.getLine();
        this.ranking = campaignSection.getSort().doubleValue();
        this.factor = campaignSection.getFactor();
        this.factorType = campaignSection.getFactorType();
    }

    public Map<String, Object> toMap() {
        HashedMap map = new HashedMap();
        map.put("id", this.id);
        map.put("campaignId", this.campaignId);
        if (this.line != null) {
            map.put("line", this.line.doubleValue());
        }
        if (this.factor != null) {
            map.put("factor", this.factor.doubleValue());
        }
        if (this.conditionType != null) {
            map.put("conditionType", this.conditionType);
        }
        if (this.factorType != null) {
            map.put("factorType", this.factorType);
        }
        if (this.ranking != null) {
            map.put("ranking", this.ranking);
        }
        if (this.campaignSectionProducts != null) {
            ArrayList<Map<String, Object>> sectionProductList = new ArrayList<Map<String, Object>>();
            for (PsCampaignSectionProductVO sectionProductVO : this.campaignSectionProducts) {
                sectionProductList.add(sectionProductVO.toMap());
            }
            map.put("sectionProducts", sectionProductList);
        }
        return map;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public Integer getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    public BigDecimal getLine() {
        return this.line;
    }

    public void setLine(BigDecimal line) {
        this.line = line;
    }

    public BigDecimal getFactor() {
        return this.factor;
    }

    public void setFactor(BigDecimal factor) {
        this.factor = factor;
    }

    public Integer getFactorType() {
        return this.factorType;
    }

    public void setFactorType(Integer factorType) {
        this.factorType = factorType;
    }

    public Double getRanking() {
        return this.ranking;
    }

    public void setRanking(Double ranking) {
        this.ranking = ranking;
    }

    public List<PsCampaignSectionProductVO> getCampaignSectionProducts() {
        return this.campaignSectionProducts;
    }

    public void setCampaignSectionProducts(List<PsCampaignSectionProductVO> campaignSectionProducts) {
        this.campaignSectionProducts = campaignSectionProducts;
    }
}

