package com.thebeastshop.scm.vo;

import java.math.BigDecimal;

import org.springframework.util.StringUtils;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.SoPackage;

/**
 * 包裹行vo
 * 
 * @author 徐玲玲
 *
 * 2016年8月25日
 */
public class SoPackageSkuVO extends AbstractDomain{
    private Integer id;
    private Integer salesOrderId;
	private Integer packageId;
	private Integer presaleId;
	private Integer presaleStatus;
	private String code;
	private String skuCode;
	private Integer quantity;
	private BigDecimal unitPrice;
	private BigDecimal totalPrice;
	private BigDecimal unitDiscount;
	private BigDecimal totalDiscount;
	private BigDecimal unitPriceAfterDiscount;
	private BigDecimal totalPriceAfterDiscount;
	private BigDecimal unitPoint;
	private BigDecimal totalPoint;
	private BigDecimal unitPointDeduction;
	private BigDecimal totalPointDeduction;
	private BigDecimal unitPriceAfterDeduction;
	private BigDecimal totalPriceAfterDeduction;
	private BigDecimal aptDiscountOnHead;
	private BigDecimal aptUDiscountOnHead;
	private BigDecimal aptPointOnHead;
	private BigDecimal aptUPointOnHead;
	private BigDecimal aptPointOnHeadDeduction;
	private BigDecimal aptUPointOnHeadDeduction;
	private BigDecimal aptServiceFeeAmount;
	private BigDecimal aptUServiceFeeAmount;
	private BigDecimal aptGiftCardAmount;
	private BigDecimal aptUGiftCardAmount;
	private BigDecimal unitPriceAfterApt;
	private BigDecimal totalPriceAfterApt;
	private Integer isJit;						// 是否来单制作（高单价的组合配方SKU），0否1是
	private Integer isGift;						// 是否赠品
	private Integer addBy;	
	private String remark;
	private Integer oid;
	private Integer cutStatus;
	private Integer cancleQuantity;
	private Integer crossBorderFlag;
	private String weight;
	private String taxNo;
	private String refundStatus;

    // self
    private String skuName;		
    private String skuNameCn;				// sku中文名称
    private String skuCategoryFullName;
    private Integer clearanceWay;			// 通关方式（0：未知，1：BC，2：个人）
    private Integer whetherConsignment;		// 是否代销(1：是，0：否)
    private String skuImg;					// sku图片

    // 正式路径前缀
    private static final String IMG_ZHENGSHI = "http://img.thebeastshop.com/";
    // 测试路径前缀
//    private static final String IMG_CESHI = "http://beasttest.oss-cn-hangzhou.aliyuncs.com/";

    /**
     * 通关方式
     *
     * @return
     */
    public String getClearanceWayName() {
        return 	clearanceWay == null ? "" :
        		clearanceWay.equals(SoPackage.CLEARANCE_WAY_UNKNOWN) ? "未知" :
        		clearanceWay.equals(SoPackage.CLEARANCE_WAY_BC) ? "BC" :
        		clearanceWay.equals(SoPackage.CLEARANCE_WAY_PERSONAL) ? "个人" : "";

    }

    public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	public Integer getCancleQuantity() {
		return cancleQuantity;
	}

	public void setCancleQuantity(Integer cancleQuantity) {
		this.cancleQuantity = cancleQuantity;
	}

	// manual generate
    public Boolean getIsPresaleSku(){
        return presaleId==null?false:true;
    }

    // auto generate
    public 	Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getSalesOrderId() {
        return salesOrderId;
    }

    public void setSalesOrderId(Integer salesOrderId) {
        this.salesOrderId = salesOrderId;
    }

    public Integer getPackageId() {
        return packageId;
    }

    public void setPackageId(Integer packageId) {
        this.packageId = packageId;
    }

    public Integer getPresaleId() {
        return presaleId;
    }

    public void setPresaleId(Integer presaleId) {
        this.presaleId = presaleId;
    }

    public Integer getPresaleStatus() {
        return presaleStatus;
    }

    public void setPresaleStatus(Integer presaleStatus) {
        this.presaleStatus = presaleStatus;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getUnitDiscount() {
        return unitDiscount;
    }

    public void setUnitDiscount(BigDecimal unitDiscount) {
        this.unitDiscount = unitDiscount;
    }

    public BigDecimal getTotalDiscount() {
        return totalDiscount;
    }

    public void setTotalDiscount(BigDecimal totalDiscount) {
        this.totalDiscount = totalDiscount;
    }

    public BigDecimal getUnitPriceAfterDiscount() {
        return unitPriceAfterDiscount;
    }

    public void setUnitPriceAfterDiscount(BigDecimal unitPriceAfterDiscount) {
        this.unitPriceAfterDiscount = unitPriceAfterDiscount;
    }

    public BigDecimal getTotalPriceAfterDiscount() {
        return totalPriceAfterDiscount;
    }

    public void setTotalPriceAfterDiscount(BigDecimal totalPriceAfterDiscount) {
        this.totalPriceAfterDiscount = totalPriceAfterDiscount;
    }

    public BigDecimal getUnitPoint() {
        return unitPoint;
    }

    public void setUnitPoint(BigDecimal unitPoint) {
        this.unitPoint = unitPoint;
    }

    public BigDecimal getTotalPoint() {
        return totalPoint;
    }

    public void setTotalPoint(BigDecimal totalPoint) {
        this.totalPoint = totalPoint;
    }

    public BigDecimal getUnitPointDeduction() {
        return unitPointDeduction;
    }

    public void setUnitPointDeduction(BigDecimal unitPointDeduction) {
        this.unitPointDeduction = unitPointDeduction;
    }

    public BigDecimal getTotalPointDeduction() {
        return totalPointDeduction;
    }

    public void setTotalPointDeduction(BigDecimal totalPointDeduction) {
        this.totalPointDeduction = totalPointDeduction;
    }

    public BigDecimal getUnitPriceAfterDeduction() {
        return unitPriceAfterDeduction;
    }

    public void setUnitPriceAfterDeduction(BigDecimal unitPriceAfterDeduction) {
        this.unitPriceAfterDeduction = unitPriceAfterDeduction;
    }

    public BigDecimal getTotalPriceAfterDeduction() {
        return totalPriceAfterDeduction;
    }

    public void setTotalPriceAfterDeduction(BigDecimal totalPriceAfterDeduction) {
        this.totalPriceAfterDeduction = totalPriceAfterDeduction;
    }

    public BigDecimal getAptDiscountOnHead() {
        return aptDiscountOnHead;
    }

    public void setAptDiscountOnHead(BigDecimal aptDiscountOnHead) {
        this.aptDiscountOnHead = aptDiscountOnHead;
    }

    public BigDecimal getAptUDiscountOnHead() {
        return aptUDiscountOnHead;
    }

    public void setAptUDiscountOnHead(BigDecimal aptUDiscountOnHead) {
        this.aptUDiscountOnHead = aptUDiscountOnHead;
    }

    public BigDecimal getAptPointOnHead() {
        return aptPointOnHead;
    }

    public void setAptPointOnHead(BigDecimal aptPointOnHead) {
        this.aptPointOnHead = aptPointOnHead;
    }

    public BigDecimal getAptUPointOnHead() {
        return aptUPointOnHead;
    }

    public void setAptUPointOnHead(BigDecimal aptUPointOnHead) {
        this.aptUPointOnHead = aptUPointOnHead;
    }

    public BigDecimal getAptPointOnHeadDeduction() {
        return aptPointOnHeadDeduction;
    }

    public void setAptPointOnHeadDeduction(BigDecimal aptPointOnHeadDeduction) {
        this.aptPointOnHeadDeduction = aptPointOnHeadDeduction;
    }

    public BigDecimal getAptUPointOnHeadDeduction() {
        return aptUPointOnHeadDeduction;
    }

    public void setAptUPointOnHeadDeduction(BigDecimal aptUPointOnHeadDeduction) {
        this.aptUPointOnHeadDeduction = aptUPointOnHeadDeduction;
    }

    public BigDecimal getAptServiceFeeAmount() {
        return aptServiceFeeAmount;
    }

    public void setAptServiceFeeAmount(BigDecimal aptServiceFeeAmount) {
        this.aptServiceFeeAmount = aptServiceFeeAmount;
    }

    public BigDecimal getAptUServiceFeeAmount() {
        return aptUServiceFeeAmount;
    }

    public void setAptUServiceFeeAmount(BigDecimal aptUServiceFeeAmount) {
        this.aptUServiceFeeAmount = aptUServiceFeeAmount;
    }

    public BigDecimal getAptGiftCardAmount() {
        return aptGiftCardAmount;
    }

    public void setAptGiftCardAmount(BigDecimal aptGiftCardAmount) {
        this.aptGiftCardAmount = aptGiftCardAmount;
    }

    public BigDecimal getAptUGiftCardAmount() {
        return aptUGiftCardAmount;
    }

    public void setAptUGiftCardAmount(BigDecimal aptUGiftCardAmount) {
        this.aptUGiftCardAmount = aptUGiftCardAmount;
    }

    public BigDecimal getUnitPriceAfterApt() {
        return unitPriceAfterApt;
    }

    public void setUnitPriceAfterApt(BigDecimal unitPriceAfterApt) {
        this.unitPriceAfterApt = unitPriceAfterApt;
    }

    public BigDecimal getTotalPriceAfterApt() {
        return totalPriceAfterApt;
    }

    public void setTotalPriceAfterApt(BigDecimal totalPriceAfterApt) {
        this.totalPriceAfterApt = totalPriceAfterApt;
    }

    public Integer getIsGift() {
        return isGift;
    }

    public void setIsGift(Integer isGift) {
        this.isGift = isGift;
    }

    public Integer getIsJit() {
        return isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

    public Integer getAddBy() {
        return addBy;
    }

    public void setAddBy(Integer addBy) {
        this.addBy = addBy;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setSkuCategoryFullName(String skuCategoryFullName) {
        this.skuCategoryFullName = skuCategoryFullName;
    }

	public Integer getOid() {
		return oid;
	}

	public void setOid(Integer oid) {
		this.oid = oid;
	}

	public Integer getCutStatus() {
		return cutStatus;
	}

	public void setCutStatus(Integer cutStatus) {
		this.cutStatus = cutStatus;
	}

	public String getWeight() {
		return weight;
	}

	public void setWeight(String weight) {
		this.weight = weight;
	}

	public String getTaxNo() {
		return taxNo;
	}

	public void setTaxNo(String taxNo) {
		this.taxNo = taxNo;
	}

	public String getRefundStatus() {
		return refundStatus;
	}

	public void setRefundStatus(String refundStatus) {
		this.refundStatus = refundStatus;
	}

	public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}

	public String getSkuNameCn() {
		return skuNameCn;
	}

	public void setSkuNameCn(String skuNameCn) {
		this.skuNameCn = skuNameCn;
	}

	public Integer getClearanceWay() {
		return clearanceWay;
	}

	public void setClearanceWay(Integer clearanceWay) {
		this.clearanceWay = clearanceWay;
	}

	public String getSkuCategoryFullName() {
		return skuCategoryFullName;
	}

	public Integer getWhetherConsignment() {
		return whetherConsignment;
	}
	public void setWhetherConsignment(Integer whetherConsignment) {
		this.whetherConsignment = whetherConsignment;
	}

	public String getSkuImg() {
		return skuImg;
	}

	public void setSkuImg(String skuImg) {
		this.skuImg = skuImg;
	}

	// 获取sku图片路径
	public String getSkuImgURL() {
		return StringUtils.isEmpty(skuImg)? skuImg : IMG_ZHENGSHI + skuImg;
	}
}