/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.es;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.es.PsAttributeVO;
import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.es.PsChnProdSaleSku;
import com.thebeastshop.scm.es.PsChnProdTimeCodeInfo;
import com.thebeastshop.scm.es.PsDeliveryVO;
import com.thebeastshop.scm.es.PsDynmContentVO;
import com.thebeastshop.scm.es.PsSpvVO;
import com.thebeastshop.scm.es.PsTagVO;
import com.thebeastshop.scm.es.PsUpdateVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class PsProductVO
extends PsUpdateVO {
    private String id;
    private String code;
    private Integer combined;
    private BigDecimal listPrice;
    private LinkedHashMap<String, Map> listPriceList;
    private Integer allowVipDiscount;
    private Integer allowNoteCard;
    private Integer prepareDays;
    private Integer selectDeliveryDays;
    private String picList;
    private String picDetail;
    private String picThumb;
    private String picDetailMul;
    private Integer expressType;
    private String name;
    private String nameCn;
    private String skuCategoryDesc;
    private Long categoryId;
    private String categoryCode;
    private List<PsCampaignVO> campaignList = new ArrayList<PsCampaignVO>();
    private Integer seq;
    private Integer sort1;
    private Integer sort2;
    private String description;
    private Date saleStartDate;
    private Integer crossBorderFlag;
    private Map<String, String> canSaleSkuMap;
    private Map<String, String> canSeeSkuMap;
    private List<String> skuCodes = new ArrayList<String>();
    private List<String> smallIconList = new ArrayList<String>();
    private List<String> largeIconList = new ArrayList<String>();
    private List<String> chnSaleChnCodes = new ArrayList<String>();
    private List<String> onShelfChnCodes = new ArrayList<String>();
    private List<String> offShelfChnCodes = new ArrayList<String>();
    private List<Map> frontCategories = new ArrayList<Map>();
    private List<Map> stocks = new ArrayList<Map>();
    private List<PsTagVO> psTags = new ArrayList<PsTagVO>();
    private List<PsDeliveryVO> selfDeliveries = new ArrayList<PsDeliveryVO>();
    private List<PsDynmContentVO> dynmContents = new ArrayList<PsDynmContentVO>();
    private List<PsChnProdSaleSku> chnCanSaleSKu = new ArrayList<PsChnProdSaleSku>();
    private List<PsChnProdSaleSku> chnCanSeeSKu = new ArrayList<PsChnProdSaleSku>();
    private List<Map> brandList = new ArrayList<Map>();
    private List<PsChnProdTimeCodeInfo> channelProdInfo = new ArrayList<PsChnProdTimeCodeInfo>();
    private List<Map> labels = new ArrayList<Map>();
    private List<PsAttributeVO> attributeList = new ArrayList<PsAttributeVO>();
    private List<PsSpvVO> spvList = new ArrayList<PsSpvVO>();
    private String primaryUpdateTime;
    private Long primaryUpdateLong;

    public static List<PsSpvVO> getAvaiableSpvs(String chnCode, PsProductVO psProductVO) {
        ArrayList<PsSpvVO> list = new ArrayList<PsSpvVO>();
        Map<String, String> canSaleSkuMap = PsProductVO.getCanSaleSkuMap(chnCode, psProductVO);
        Map<String, String> canSeeSkuMap = PsProductVO.getCanSeeSkuMap(chnCode, psProductVO);
        List<PsSpvVO> spvVOs = psProductVO.getSpvList();
        if (CollectionUtils.isEmpty(spvVOs)) {
            return Lists.newArrayList();
        }
        for (PsSpvVO spvVO : spvVOs) {
            if (!PsSpvVO.isAvaible(chnCode, true, canSaleSkuMap, canSeeSkuMap, spvVO)) continue;
            list.add(spvVO);
        }
        return list;
    }

    public static List<Integer> getAvaiableSpvIds(String chnCode, PsProductVO psProductVO) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<PsSpvVO> spvVOs = PsProductVO.getAvaiableSpvs(chnCode, psProductVO);
        for (PsSpvVO psSpvVO : spvVOs) {
            ids.add(psSpvVO.getSpvId());
        }
        return ids;
    }

    public static Map<String, String> getCanSeeSkuMap(String chnCode, PsProductVO psProductVO) {
        if (psProductVO.canSeeSkuMap != null) {
            return psProductVO.canSeeSkuMap;
        }
        HashedMap canSeeSkuMap = new HashedMap();
        List<PsChnProdSaleSku> canSeeSkuList = psProductVO.getChnCanSeeSKu();
        if (CollectionUtils.isEmpty(canSeeSkuList)) {
            return canSeeSkuMap;
        }
        PsChnProdSaleSku canSeeSku = null;
        for (PsChnProdSaleSku chnProdSaleSkuVO : canSeeSkuList) {
            if (!StringUtils.equals((CharSequence)chnProdSaleSkuVO.getChnCode(), (CharSequence)chnCode)) continue;
            canSeeSku = chnProdSaleSkuVO;
            break;
        }
        if (canSeeSku != null) {
            for (String skuCode : canSeeSku.getCanSkus()) {
                canSeeSkuMap.put(skuCode, skuCode);
            }
        }
        psProductVO.canSeeSkuMap = canSeeSkuMap;
        return canSeeSkuMap;
    }

    public static Map<String, String> getCanSaleSkuMap(String chnCode, PsProductVO psProductVO) {
        if (psProductVO.canSaleSkuMap != null) {
            return psProductVO.canSaleSkuMap;
        }
        HashedMap canSaleSkuMap = new HashedMap();
        List<PsChnProdSaleSku> canSaleSkuList = psProductVO.getChnCanSaleSKu();
        if (CollectionUtils.isEmpty(canSaleSkuList)) {
            return canSaleSkuMap;
        }
        PsChnProdSaleSku canSaleSku = null;
        for (PsChnProdSaleSku chnProdSaleSkuVO : canSaleSkuList) {
            if (!StringUtils.equals((CharSequence)chnProdSaleSkuVO.getChnCode(), (CharSequence)chnCode)) continue;
            canSaleSku = chnProdSaleSkuVO;
            break;
        }
        if (canSaleSku != null) {
            for (String skuCode : canSaleSku.getCanSkus()) {
                canSaleSkuMap.put(skuCode, skuCode);
            }
        }
        psProductVO.canSaleSkuMap = canSaleSkuMap;
        return canSaleSkuMap;
    }

    public List<String> getPicDetailMuls() {
        if (StringUtils.isBlank((CharSequence)this.picDetailMul)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.picDetailMul.split(","));
    }

    public void addIcon(String smallIcon, String largeIcon) {
        if (StringUtils.isNotBlank((CharSequence)smallIcon)) {
            this.smallIconList.add(smallIcon);
        }
        if (StringUtils.isNotBlank((CharSequence)largeIcon)) {
            this.largeIconList.add(largeIcon);
        }
    }

    public Integer getSeq() {
        if (this.seq == null) {
            return 9999;
        }
        return this.seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Integer getSort1() {
        if (this.sort1 == null) {
            return 99999;
        }
        return this.sort1;
    }

    public void setSort1(Integer sort1) {
        this.sort1 = sort1;
    }

    public Integer getSort2() {
        if (this.sort2 == null) {
            return 99999;
        }
        return this.sort2;
    }

    public void setSort2(Integer sort2) {
        this.sort2 = sort2;
    }

    public Integer getExpressType() {
        if (this.expressType == null) {
            return 3;
        }
        return this.expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public Long getCategoryId() {
        if (this.categoryId == null) {
            return 0L;
        }
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryCode() {
        return StringUtils.trimToEmpty((String)this.categoryCode);
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public List<Map> getFrontCategories() {
        return this.frontCategories;
    }

    public void setFrontCategories(List<Map> frontCategories) {
        if (frontCategories == null) {
            return;
        }
        this.frontCategories = frontCategories;
    }

    public List<PsCampaignVO> getCampaignList() {
        return this.campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }

    public List<Map> getStocks() {
        return this.stocks;
    }

    public void setStocks(List<Map> stocks) {
        this.stocks = stocks;
    }

    public List<String> getSmallIconList() {
        return this.smallIconList;
    }

    public void setSmallIconList(List<String> smallIconList) {
        if (smallIconList == null) {
            return;
        }
        this.smallIconList = smallIconList;
    }

    public List<String> getLargeIconList() {
        return this.largeIconList;
    }

    public void setLargeIconList(List<String> largeIconList) {
        if (largeIconList == null) {
            return;
        }
        this.largeIconList = largeIconList;
    }

    public List<PsTagVO> getPsTags() {
        return this.psTags;
    }

    public void setPsTags(List<PsTagVO> psTags) {
        if (psTags == null) {
            return;
        }
        this.psTags = psTags;
    }

    public List<PsDeliveryVO> getSelfDeliveries() {
        return this.selfDeliveries;
    }

    public void setSelfDeliveries(List<PsDeliveryVO> selfDeliveries) {
        if (selfDeliveries == null) {
            return;
        }
        this.selfDeliveries = selfDeliveries;
    }

    public List<PsChnProdSaleSku> getChnCanSaleSKu() {
        return this.chnCanSaleSKu;
    }

    public void setChnCanSaleSKu(List<PsChnProdSaleSku> chnCanSaleSKu) {
        if (chnCanSaleSKu == null) {
            return;
        }
        this.chnCanSaleSKu = chnCanSaleSKu;
    }

    public List<String> getChnSaleChnCodes() {
        return this.chnSaleChnCodes;
    }

    public void setChnSaleChnCodes(List<String> chnSaleChnCodes) {
        if (chnSaleChnCodes == null) {
            return;
        }
        this.chnSaleChnCodes = chnSaleChnCodes;
    }

    public List<String> getOnShelfChnCodes() {
        return this.onShelfChnCodes;
    }

    public void setOnShelfChnCodes(List<String> onShelfChnCodes) {
        if (onShelfChnCodes == null) {
            return;
        }
        this.onShelfChnCodes = onShelfChnCodes;
    }

    public List<String> getOffShelfChnCodes() {
        return this.offShelfChnCodes;
    }

    public void setOffShelfChnCodes(List<String> offShelfChnCodes) {
        if (offShelfChnCodes == null) {
            return;
        }
        this.offShelfChnCodes = offShelfChnCodes;
    }

    public List<PsDynmContentVO> getDynmContents() {
        return this.dynmContents;
    }

    public void setDynmContents(List<PsDynmContentVO> dynmContents) {
        if (dynmContents == null) {
            return;
        }
        this.dynmContents = dynmContents;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public LinkedHashMap<String, Map> getListPriceMapList() {
        return this.listPriceList;
    }

    public void setListPriceMapList(LinkedHashMap<String, Map> listPriceList) {
        this.listPriceList = listPriceList;
    }

    public List<Map> getListPriceList() {
        ArrayList<Map> list = new ArrayList<Map>();
        if (MapUtils.isNotEmpty(this.listPriceList)) {
            for (String key : this.listPriceList.keySet()) {
                Map map = this.listPriceList.get(key);
                list.add(map);
            }
        }
        return list;
    }

    public Integer getAllowVipDiscount() {
        return this.allowVipDiscount;
    }

    public void setAllowVipDiscount(Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return this.allowNoteCard;
    }

    public void setAllowNoteCard(Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }

    public Integer getPrepareDays() {
        return this.prepareDays;
    }

    public void setPrepareDays(Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return this.selectDeliveryDays;
    }

    public void setSelectDeliveryDays(Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

    public String getPicList() {
        return this.picList == null ? "" : this.picList;
    }

    public void setPicList(String picList) {
        this.picList = picList;
    }

    public String getPicDetail() {
        return this.picDetail == null ? "" : this.picDetail;
    }

    public void setPicDetail(String picDetail) {
        this.picDetail = picDetail;
    }

    public String getPicThumb() {
        return this.picThumb == null ? "" : this.picThumb;
    }

    public void setPicThumb(String picThumb) {
        this.picThumb = picThumb;
    }

    public String getName() {
        return StringUtils.trimToEmpty((String)this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return this.nameCn == null ? "" : this.nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public List<String> getSkuCodes() {
        return this.skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        if (skuCodes == null) {
            return;
        }
        this.skuCodes = skuCodes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSkuCategoryDesc() {
        return this.skuCategoryDesc;
    }

    public void setSkuCategoryDesc(String skuCategoryDesc) {
        this.skuCategoryDesc = skuCategoryDesc;
    }

    public List<PsChnProdSaleSku> getChnCanSeeSKu() {
        return this.chnCanSeeSKu;
    }

    public void setChnCanSeeSKu(List<PsChnProdSaleSku> chnCanSeeSKu) {
        if (chnCanSeeSKu == null) {
            return;
        }
        this.chnCanSeeSKu = chnCanSeeSKu;
    }

    public Date getSaleStartDate() {
        return this.saleStartDate;
    }

    public void setSaleStartDate(Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public String getPicDetailMul() {
        return StringUtils.trimToEmpty((String)this.picDetailMul);
    }

    public void setPicDetailMul(String picDetailMul) {
        this.picDetailMul = picDetailMul;
    }

    public String getDescription() {
        return StringUtils.trimToEmpty((String)this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Map> getBrandList() {
        return this.brandList;
    }

    public void setBrandList(List<Map> brandList) {
        this.brandList = brandList;
    }

    public List<PsChnProdTimeCodeInfo> getChannelProdInfo() {
        return this.channelProdInfo;
    }

    public void setChannelProdInfo(List<PsChnProdTimeCodeInfo> channelProdInfo) {
        this.channelProdInfo = channelProdInfo;
    }

    public Integer getCrossBorderFlag() {
        return this.crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public List<Map> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Map> labels) {
        this.labels = labels;
    }

    public List<PsAttributeVO> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<PsAttributeVO> attributeList) {
        this.attributeList = attributeList;
    }

    public List<PsSpvVO> getSpvList() {
        return this.spvList;
    }

    public void setSpvList(List<PsSpvVO> spvList) {
        this.spvList = spvList;
    }

    public Integer getCombined() {
        return this.combined;
    }

    public void setCombined(Integer combined) {
        this.combined = combined;
    }

    public String getPrimaryUpdateTime() {
        return this.primaryUpdateTime;
    }

    public void setPrimaryUpdateTime(String primaryUpdateTime) {
        this.primaryUpdateTime = primaryUpdateTime;
    }

    public Long getPrimaryUpdateLong() {
        return this.primaryUpdateLong;
    }

    public void setPrimaryUpdateLong(Long primaryUpdateLong) {
        this.primaryUpdateLong = primaryUpdateLong;
    }
}

