package com.thebeastshop.scm.vo.lottery;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.joda.time.format.DateTimeFormat;

import pers.richard.ormybatis.domain.core.AbstractDomain;
import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.scm.po.LotteryActivity;
import com.thebeastshop.scm.po.LotteryActivityAward;
import com.thebeastshop.scm.po.LotteryActivityPrize;

/**
 * 抽奖活动保存VO
 * @author donghui
 */
public class LotteryActivityDraw extends AbstractDomain {
	private Integer id;
	private String name;
	private String startTime; 
	private String endTime; 
	private Integer consumePoint;
	
	private List<Integer> awardId = new ArrayList<>();
	private List<String> awardName = new ArrayList<>();
	private List<Integer> awardQuantity = new ArrayList<>();
	private List<Integer> awardOdds = new ArrayList<>();
	private List<String> awardContent = new ArrayList<>();
	
	private List<String> prizeType = new ArrayList<>();
	private List<Integer> prizeTypeNum = new ArrayList<>();
	
	public LotteryActivityDraw() {	} 
	
	public LotteryActivity toLotteryActivity(){
		LotteryActivity lotteryActivity = new LotteryActivity();
		lotteryActivity.setId(this.id);
		lotteryActivity.setName(this.name);
		lotteryActivity.setStartTime(DateTimeFormat.forPattern("yyyy-MM-dd HH:mm").parseDateTime(this.startTime).toDate());
		lotteryActivity.setEndTime(DateTimeFormat.forPattern("yyyy-MM-dd HH:mm").parseDateTime(this.endTime).toDate());
		lotteryActivity.setConsumePoint(this.consumePoint);
		lotteryActivity.setUpdateTime(new Date());
		if (this.id == null) {
			lotteryActivity.setCreateTime(new Date());
		}
		return lotteryActivity;
	}
	
	public List<LotteryActivityAward> toLotteryActivityAwardList(Integer lotteryActivityId){
		List<LotteryActivityAward> result = new ArrayList<>();
		for (int i = 0; i < awardName.size(); i++) {
			LotteryActivityAward award = new LotteryActivityAward();
			award.setId(ObjUtils.get(awardId, i));
			award.setLotteryActivityId(lotteryActivityId);
			award.setName(ObjUtils.get(awardName, i));
			award.setQuantity(ObjUtils.get(awardQuantity, i));
			award.setOdds(ObjUtils.get(awardOdds, i));
			award.setContent(ObjUtils.get(awardContent, i));
			if (award.getId() == null) {
				award.setWinQuantity(0);
				award.setVersion(0);
			}
			result.add(award);
		}
		return result;
	}
	
	public LotteryActivityPrize toLotteryActivityPrize(Integer lotteryActivityAwardId, int index){
		LotteryActivityPrize prize = new LotteryActivityPrize();
		prize.setLotteryActivityAwardId(lotteryActivityAwardId);
		prize.setType(ObjUtils.get(prizeType, index));
		prize.setTypeNum(ObjUtils.get(prizeTypeNum, index));
		return prize;
	}
	
	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public Integer getConsumePoint() {
		return consumePoint;
	}

	public void setConsumePoint(Integer consumePoint) {
		this.consumePoint = consumePoint;
	}
	public List<Integer> getAwardId() {
		return awardId;
	}

	public void setAwardId(List<Integer> awardId) {
		this.awardId = awardId;
	}
	public List<String> getAwardName() {
		return awardName;
	}

	public void setAwardName(List<String> awardName) {
		this.awardName = awardName;
	}

	public List<Integer> getAwardQuantity() {
		return awardQuantity;
	}

	public void setAwardQuantity(List<Integer> awardQuantity) {
		this.awardQuantity = awardQuantity;
	}

	public List<Integer> getAwardOdds() {
		return awardOdds;
	}

	public void setAwardOdds(List<Integer> awardOdds) {
		this.awardOdds = awardOdds;
	}

	public List<String> getAwardContent() {
		return awardContent;
	}

	public void setAwardContent(List<String> awardContent) {
		this.awardContent = awardContent;
	}

	public List<String> getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(List<String> prizeType) {
		this.prizeType = prizeType;
	}

	public List<Integer> getPrizeTypeNum() {
		return prizeTypeNum;
	}

	public void setPrizeTypeNum(List<Integer> prizeTypeNum) {
		this.prizeTypeNum = prizeTypeNum;
	}
}