/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.es;

import com.thebeastshop.scm.es.DiscountTypeEnum;
import com.thebeastshop.scm.es.PsCampaignSectionVO;
import com.thebeastshop.scm.es.PsUpdateVO;
import com.thebeastshop.scm.po.Campaign;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class PsCampaignVO
extends PsUpdateVO {
    private Long id;
    private String name;
    private String title;
    private Integer state;
    private Integer productScopeId;
    private Integer discountTypeId;
    private Integer crossBorderFlag;
    private String discountTypeName;
    private List<Integer> accessWayIds;
    private List<Integer> memberLevels;
    private Integer cumulative;
    private List<PsCampaignSectionVO> sections;
    private Date startTime;
    private Date expireTime;

    public PsCampaignVO() {
    }

    public PsCampaignVO(Campaign campaign) {
        this.id = campaign.getId().longValue();
        this.name = campaign.getName();
        this.title = campaign.getTitle();
        this.state = campaign.getState();
        this.productScopeId = campaign.getProductScope();
        this.discountTypeId = campaign.getDiscountType();
        DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.valueOf(this.discountTypeId);
        if (discountTypeEnum != null) {
            this.discountTypeName = discountTypeEnum.getName();
        }
        this.crossBorderFlag = campaign.getCrossBorderFlag();
        this.accessWayIds = this.splitIds(campaign.getAccessWay());
        this.memberLevels = this.splitIds(campaign.getMemberLevel());
        this.cumulative = campaign.getCumulative();
        this.startTime = campaign.getStartTime();
        this.expireTime = campaign.getExpireTime();
    }

    public Map<String, Object> toMap() {
        HashedMap map = new HashedMap();
        map.put("id", this.id);
        map.put("name", this.name);
        map.put("title", this.title);
        map.put("state", this.state);
        map.put("productScopeId", this.productScopeId);
        map.put("discountTypeId", this.discountTypeId);
        if (this.discountTypeName != null) {
            map.put("discountTypeName", this.discountTypeName);
        }
        map.put("crossBorderFlag", this.crossBorderFlag);
        map.put("accessWayIds", this.accessWayIds);
        map.put("memberLevels", this.memberLevels);
        map.put("cumulative", this.cumulative);
        map.put("startTime", this.startTime);
        map.put("expireTime", this.expireTime);
        if (this.sections != null) {
            ArrayList<Map<String, Object>> sectionMaps = new ArrayList<Map<String, Object>>();
            for (PsCampaignSectionVO sectionVO : this.sections) {
                sectionMaps.add(sectionVO.toMap());
            }
            map.put("campaignSections", sectionMaps);
        }
        return map;
    }

    private List<Integer> splitIds(String str) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{str})) {
            String[] idArr;
            for (String id : idArr = str.split(",")) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id})) continue;
                try {
                    ids.add(Integer.valueOf(id));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return ids;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getProductScopeId() {
        return this.productScopeId;
    }

    public void setProductScopeId(Integer productScopeId) {
        this.productScopeId = productScopeId;
    }

    public Integer getDiscountTypeId() {
        return this.discountTypeId;
    }

    public void setDiscountTypeId(Integer discountTypeId) {
        this.discountTypeId = discountTypeId;
    }

    public Integer getCrossBorderFlag() {
        return this.crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public String getDiscountTypeName() {
        return this.discountTypeName;
    }

    public void setDiscountTypeName(String discountTypeName) {
        this.discountTypeName = discountTypeName;
    }

    public List<Integer> getAccessWayIds() {
        return this.accessWayIds;
    }

    public void setAccessWayIds(List<Integer> accessWayIds) {
        this.accessWayIds = accessWayIds;
    }

    public List<Integer> getMemberLevels() {
        return this.memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
    }

    public Integer getCumulative() {
        return this.cumulative;
    }

    public void setCumulative(Integer cumulative) {
        this.cumulative = cumulative;
    }

    public List<PsCampaignSectionVO> getSections() {
        return this.sections;
    }

    public void setSections(List<PsCampaignSectionVO> sections) {
        this.sections = sections;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }
}

