package com.thebeastshop.scm.vo.lottery;

import java.util.List;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.LotteryActivityAward;
import com.thebeastshop.scm.po.LotteryActivityPrize;

/**
 * 中奖VO
 * @author donghui
 */
public class LotteryActivityResultVO extends AbstractDomain {
	private Boolean isCheck;//抽奖检验是否通过
	private String failReason;//检验失败原因
	
	private LotteryActivityAward award;//奖项(为null:表示没中奖)
	private List<LotteryActivityPrize> prizeList;//奖品(为null:表示没中奖)
	private Integer lotteryActivityPrizeRecordId;//中奖记录ID(为null:表示没中奖)
	
	private LotteryActivityResultVO() {} 
	
	/**
	 * 抽奖的结果
	 */
	public static LotteryActivityResultVO newInstanceSuccess(LotteryActivityAward award, List<LotteryActivityPrize> prizeList, Integer lotteryActivityPrizeRecordId) {
		LotteryActivityResultVO vo = new LotteryActivityResultVO();
		vo.setIsCheck(true);
		vo.setAward(award);
		vo.setPrizeList(prizeList);
		vo.setLotteryActivityPrizeRecordId(lotteryActivityPrizeRecordId);
		return vo;
	} 
	
	/**
	 * 抽奖资格失败的结果
	 */
	public static LotteryActivityResultVO newInstanceFail(String failReason) {
		LotteryActivityResultVO vo = new LotteryActivityResultVO();
		vo.setIsCheck(false);
		vo.setFailReason(failReason);
		return vo;
	} 
	
	public Boolean getIsWin() {
		return isCheck;
	}

	public void setIsCheck(Boolean isCheck) {
		this.isCheck = isCheck;
	}

	public String getFailReason() {
		return failReason;
	}

	public void setFailReason(String failReason) {
		this.failReason = failReason;
	}
	public LotteryActivityAward getAward() {
		return award;
	}

	public void setAward(LotteryActivityAward award) {
		this.award = award;
	}

	public Integer getLotteryActivityPrizeRecordId() {
		return lotteryActivityPrizeRecordId;
	}

	public void setLotteryActivityPrizeRecordId(Integer lotteryActivityPrizeRecordId) {
		this.lotteryActivityPrizeRecordId = lotteryActivityPrizeRecordId;
	}
	public List<LotteryActivityPrize> getPrizeList() {
		return prizeList;
	}

	public void setPrizeList(List<LotteryActivityPrize> prizeList) {
		this.prizeList = prizeList;
	}
}
