package com.thebeastshop.scm.po;

import java.util.HashMap;
import java.util.Map;

import pers.richard.ormybatis.domain.po.IdPo;

public class LotteryActivityAward extends IdPo {
	private Integer lotteryActivityId;
	private String name;
	private Integer quantity;
	private Integer odds;
	private String content;
	private Integer stock;
	private Integer version;
	
	public LotteryActivityAward(){}
	
	public final static String
		F_LOTTERY_ACTIVITY_ID = "lottery_activity_id",
		F_NAME = "name",
		F_QUANTITY = "quantity",
		F_ODDS = "odds",
		F_CONTENT = "content",
		F_STOCK = "stock",
		F_VERSION = "version";
	

	public Integer getLotteryActivityId() {return lotteryActivityId;}
	public void setLotteryActivityId(Integer lotteryActivityId) {this.lotteryActivityId = lotteryActivityId;}

	public String getName() {return name;}
	public void setName(String name) {this.name = name;}

	public Integer getQuantity() {return quantity;}
	public void setQuantity(Integer quantity) {this.quantity = quantity;}

	public Integer getOdds() {return odds;}
	public void setOdds(Integer odds) {this.odds = odds;}

	public String getContent() {return content;}
	public void setContent(String content) {this.content = content;}

	public Integer getStock() {return stock;}
	public void setStock(Integer stock) {this.stock = stock;}

	public Integer getVersion() {return version;}
	public void setVersion(Integer version) {this.version = version;}
	

	/** 奖品类型*/
	public enum Type{
		POINT("积分"),
		COUPON("优惠券");
		
		public String cn;
		private Type(String cn){
			this.cn = cn;
		}
		
		public static Map<String, String> getMap(){
			Map<String, String> map = new HashMap<>();
			for (Type type : Type.values()) {
				map.put(type.name(), type.cn);
			}
			return map;
		}
	}
}