package com.thebeastshop.scm.vo.lottery;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.LotteryActivityPrize;

/**
 * 抽奖活动编辑VO
 * @author donghui
 */
public class LotteryActivityResultVO extends AbstractDomain {
	private Boolean isCheck;//抽奖资格是否通过
	private String failReason;//抽奖资格失败原因
	private LotteryActivityPrize prize;//奖品(为null:表示没中奖)
	
	public LotteryActivityResultVO() {} 
	
	/**
	 * 抽奖的结果
	 */
	public static LotteryActivityResultVO newInstanceWin(LotteryActivityPrize prize) {
		LotteryActivityResultVO vo = new LotteryActivityResultVO();
		vo.setIsCheck(true);
		vo.setPrize(prize);
		return vo;
	} 
	
	/**
	 * 抽奖资格失败的结果
	 */
	public static LotteryActivityResultVO newInstanceFail(String failReason) {
		LotteryActivityResultVO vo = new LotteryActivityResultVO();
		vo.setIsCheck(false);
		vo.setFailReason(failReason);
		return vo;
	} 
	
	public Boolean getIsWin() {
		return isCheck;
	}

	public void setIsCheck(Boolean isCheck) {
		this.isCheck = isCheck;
	}

	public String getFailReason() {
		return failReason;
	}

	public void setFailReason(String failReason) {
		this.failReason = failReason;
	}

	public LotteryActivityPrize getPrize() {
		return prize;
	}

	public void setPrize(LotteryActivityPrize prize) {
		this.prize = prize;
	}
}
