package com.thebeastshop.scm.es;

import com.thebeastshop.scm.po.CampaignSection;
import org.apache.commons.collections.map.HashedMap;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-07-15
 */
public class PsCampaignSectionVO extends PsBaseVO {

    private Long id;

    private Long campaignId;

    private Integer conditionType;

    private BigDecimal line;

    private BigDecimal factor;

    private Integer factorType; // 价格因子影响类型

    private Double ranking;

    private List<PsCampaignSectionProductVO> campaignSectionProducts;

    public PsCampaignSectionVO() {
    }

    public PsCampaignSectionVO(CampaignSection campaignSection) {
        id = campaignSection.getId().longValue();
        campaignId = campaignSection.getCampaignId();
        conditionType = campaignSection.getType();
        line = campaignSection.getLine();
        factor = campaignSection.getFactor();
        factorType = campaignSection.getFactorType();
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashedMap();
        map.put("id", id);
        map.put("campaignId", campaignId);
        if (line != null) {
            map.put("line", line.doubleValue());
        }
        if (factor != null) {
            map.put("factor", factor.doubleValue());
        }
        if (factorType != null) {
            map.put("factorType", factorType);
        }
        if (ranking != null) {
            map.put("ranking", ranking);
        }
        return map;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public Integer getConditionType() {
        return conditionType;
    }

    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    public BigDecimal getLine() {
        return line;
    }

    public void setLine(BigDecimal line) {
        this.line = line;
    }

    public BigDecimal getFactor() {
        return factor;
    }

    public void setFactor(BigDecimal factor) {
        this.factor = factor;
    }

    public Integer getFactorType() {
        return factorType;
    }

    public void setFactorType(Integer factorType) {
        this.factorType = factorType;
    }

    public Double getRanking() {
        return ranking;
    }

    public void setRanking(Double ranking) {
        this.ranking = ranking;
    }

    public List<PsCampaignSectionProductVO> getCampaignSectionProducts() {
        return campaignSectionProducts;
    }

    public void setCampaignSectionProducts(List<PsCampaignSectionProductVO> campaignSectionProducts) {
        this.campaignSectionProducts = campaignSectionProducts;
    }
}
