package com.thebeastshop.scm.vo;

import java.util.Date;
import java.util.List;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.SoPackage;

/**
 * 包裹vo
 * 
 * @author 徐玲玲
 *
 * 2016年8月25日
 */
public class SoPackageVO extends AbstractDomain{
    private Integer id;
    private Integer salesOrderId;
	private String dispatchWarehouseCode;
	private String code;
	private Integer packageStatus;
	private Integer deliveryType;
	private Date orderMakeTime;
	private Date expectReceiveDate;
	private Date planedDeliveryDate;
	private Date deliveryTime;
	private String limitDeliveryTimeDesc;
	private Date receiveTime;
	private Integer cardType;
	private String cardContent;
	private String batchNo;
	private String csHint;
	private String remark;
	private Integer oid;
	private Integer receiptstatus;
	private Integer crossBorderFlag;		// 是否海淘
	private Integer wmsCmdShortage;
	private Date haitaoPlayDeliveryDate;
	private Integer clearanceWay;
	private Integer autoMake;

	private String identificationNo;
    private String name;

    // 包裹行
    private List<SoPackageSkuVO> soPackageSkuVOList;

    //包裹配送信息
    private SoPackageDeliveryInfoVO soPackageDeliveryInfoVO;

    //是否可修改配送
    private Integer canEditDelivery;

    //是否可取消制单
    private Integer canCancelMake;

    /**
     * 配送方式
     *
     * @return
     */
    public String getDeliveryTypeName () {
        return 	deliveryType == null ? "" :
                deliveryType.equals(SoPackage.DELIVERY_TYPE_EXPRESS) ? "快递" :
                deliveryType.equals(SoPackage.DELIVERY_TYPE_NOT_EXPRESS) ? "非快递" : "";

    }

	/**
     * 通关方式
     *
     * @return
     */
    public String getClearanceWayName() {
        return 	clearanceWay == null ? "" :
        		clearanceWay.equals(SoPackage.CLEARANCE_WAY_UNKNOWN) ? "未知" :
        		clearanceWay.equals(SoPackage.CLEARANCE_WAY_BC) ? "BC" :
        		clearanceWay.equals(SoPackage.CLEARANCE_WAY_PERSONAL) ? "个人" : "";

    }

    /**
     * 卡片类型
     *
     * @return
     */
    public String getCardTypeName() {
        return 	cardType == null ? "" :
                cardType.equals(SoPackage.CARD_TYPE_NULL) ? "不需要" :
                cardType.equals(SoPackage.CARD_TYPE_BLANK_) ? "空白" :
                cardType.equals(SoPackage.CARD_TYPE_GHOSTWRITE) ? "代写" : "";
    }

    /**
     * 包裹状态
     *
     * @return
     */
    public String getPackageStatusName() {
        return 	packageStatus == null ? "" :
                packageStatus.equals(SoPackage.PACKAGE_STATUS_UNSENT_CANCEL) ? "未发货取消" :
                packageStatus.equals(SoPackage.PACKAGE_STATUS_DEFAULT) ? "已付款" :
                packageStatus.equals(SoPackage.PACKAGE_STATUS_WAITING_MAKE) ? "待制单" :
                packageStatus.equals(SoPackage.PACKAGE_STATUS_WAITING_SEND) ? "待发货" :
                packageStatus.equals(SoPackage.PACKAGE_STATUS_WAITING_RECEIVE) ? "待收货" :
                packageStatus.equals(SoPackage.PACKAGE_STATUS_ALREADY_RECEIVE) ? "已收货" : "";
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getSalesOrderId() {
        return salesOrderId;
    }

    public void setSalesOrderId(Integer salesOrderId) {
        this.salesOrderId = salesOrderId;
    }

    public String getDispatchWarehouseCode() {
        return dispatchWarehouseCode;
    }

    public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
        this.dispatchWarehouseCode = dispatchWarehouseCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getPackageStatus() {
        return packageStatus;
    }

    public void setPackageStatus(Integer packageStatus) {
        this.packageStatus = packageStatus;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Date getOrderMakeTime() {
        return orderMakeTime;
    }

    public void setOrderMakeTime(Date orderMakeTime) {
        this.orderMakeTime = orderMakeTime;
    }

    public Date getExpectReceiveDate() {
        return expectReceiveDate;
    }

    public void setExpectReceiveDate(Date expectReceiveDate) {
        this.expectReceiveDate = expectReceiveDate;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public String getLimitDeliveryTimeDesc() {
        return limitDeliveryTimeDesc;
    }

    public void setLimitDeliveryTimeDesc(String limitDeliveryTimeDesc) {
        this.limitDeliveryTimeDesc = limitDeliveryTimeDesc;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public Integer getCardType() {
        return cardType;
    }

    public void setCardType(Integer cardType) {
        this.cardType = cardType;
    }

    public String getCardContent() {
        return cardContent;
    }

    public void setCardContent(String cardContent) {
        this.cardContent = cardContent;
    }

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getCsHint() {
        return csHint;
    }

    public void setCsHint(String csHint) {
        this.csHint = csHint;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<SoPackageSkuVO> getSoPackageSkuVOList() {
        return soPackageSkuVOList;
    }

    public void setSoPackageSkuVOList(List<SoPackageSkuVO> soPackageSkuVOList) {
        this.soPackageSkuVOList = soPackageSkuVOList;
    }

    public SoPackageDeliveryInfoVO getSoPackageDeliveryInfoVO() {
        return soPackageDeliveryInfoVO;
    }

    public void setSoPackageDeliveryInfoVO(SoPackageDeliveryInfoVO soPackageDeliveryInfoVO) {
        this.soPackageDeliveryInfoVO = soPackageDeliveryInfoVO;
    }

    public String getIdentificationNo() {
        return identificationNo;
    }

    public void setIdentificationNo(String identificationNo) {
        this.identificationNo = identificationNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

    public Integer getCanEditDelivery() {
        return canEditDelivery;
    }

    public void setCanEditDelivery(Integer canEditDelivery) {
        this.canEditDelivery = canEditDelivery;
    }

    public Integer getCanCancelMake() {
        return canCancelMake;
    }

    public void setCanCancelMake(Integer canCancelMake) {
        this.canCancelMake = canCancelMake;
    }
    
    public Integer getOid() {
		return oid;
	}
	public void setOid(Integer oid) {
		this.oid = oid;
	}

	public Integer getReceiptstatus() {
		return receiptstatus;
	}
	public void setReceiptstatus(Integer receiptstatus) {
		this.receiptstatus = receiptstatus;
	}

	public Integer getWmsCmdShortage() {
		return wmsCmdShortage;
	}
	public void setWmsCmdShortage(Integer wmsCmdShortage) {
		this.wmsCmdShortage = wmsCmdShortage;
	}

	public Date getHaitaoPlayDeliveryDate() {
		return haitaoPlayDeliveryDate;
	}
	public void setHaitaoPlayDeliveryDate(Date haitaoPlayDeliveryDate) {
		this.haitaoPlayDeliveryDate = haitaoPlayDeliveryDate;
	}

	public Integer getClearanceWay() {
		return clearanceWay;
	}
	public void setClearanceWay(Integer clearanceWay) {
		this.clearanceWay = clearanceWay;
	}

	public Integer getAutoMake() {
		return autoMake;
	}
	public void setAutoMake(Integer autoMake) {
		this.autoMake = autoMake;
	}
}