package com.thebeastshop.scm.es;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

public class PsProductVO extends PsUpdateVO {
	
	private String id;
    private String code;
    private BigDecimal listPrice;//列表价
    private Integer allowVipDiscount;//是否支持VIP折扣，1是0否
    private Integer allowNoteCard;//是否支持代写卡片，0否1是
    private Integer prepareDays;// 备货天数，默认0
    private Integer selectDeliveryDays;//可选择配送日期天数，0:尽快（不可选），n:n天内(默认n=7)
    private String picList;//图片（列表）
    private String picDetail;//图片（详情）
    private String picThumb;//图片（缩略）
    private String picDetailMul;//图片,手机端,多张以’，‘ 分割
    private Integer expressType;// 快递类型，1店送2联邦3顺丰
    private String name;//产品名
    private String nameCn;// 产品中文名
    private String skuCategoryDesc;//SKU分类描述PsProductVO
    private Long categoryId;//prod category , last update sku's category
    private String categoryCode;//prod category , last update sku's category
    private Integer seq;
    private Integer sort1;
    private Integer sort2;
	private String description;//一句话描述
	private Date saleStartDate;//开始销售时间
	private Integer crossBorderFlag;//Sku的跨境购标注 0普通１跨境购
	
	private List<String> skuCodes = new ArrayList<>();
	private List<String> smallIconList  = new ArrayList<String>();
	private List<String> largeIconList = new ArrayList<String>();
	private List<String> chnSaleChnCodes = new ArrayList<>();//所有渠道编码
	private List<String> onShelfChnCodes = new ArrayList<>();//上架渠道编码
	private List<String> offShelfChnCodes = new ArrayList<>();//下架渠道编码
	
	/** keys:{ categoryId,categoryCode,categoryName,categoryFullName,sort1,sort2} */
    private List<Map> frontCategories = new ArrayList<>();
    
    /** keys:{string:chnCode; int:stock; int:soldOut} */
    private List<Map> stocks = new ArrayList<>();
    private List<PsTagVO> psTags = new ArrayList<>();
    private List<PsDeliveryVO> selfDeliveries = new ArrayList<PsDeliveryVO>();//配送信息 区县  (自送)
    private List<PsDynmContentVO> dynmContents = new ArrayList<>();
    private List<PsChnProdSaleSku> chnCanSaleSKu = new ArrayList<>();//渠道Prod可售sku
    private List<PsChnProdSaleSku> chnCanSeeSKu = new ArrayList<>();//渠道Prod 可见 sku
    private List<Map> labels = new ArrayList<>();

	/**
     *  Map keys:{ brandId,brandNameCN,brandName,brandCountryId,brandCountryName }
     */
	private List<Map> brandList = new ArrayList<>();//所有sku下的品牌
	private List<PsChnProdTimeCodeInfo> channelProdInfo = new ArrayList<>();// 产品渠道绑定时间
	
	public PsProductVO() {}
	
	public List<String> getPicDetailMuls(){
        if (StringUtils.isBlank(picDetailMul)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(picDetailMul.split(","));
    }

    public void addIcon(String smallIcon, String largeIcon) {
		if (StringUtils.isNotBlank(smallIcon)) {
			this.smallIconList.add(smallIcon);
		}
		if (StringUtils.isNotBlank(largeIcon)) {
			this.largeIconList.add(largeIcon);
		}
	}
	
	public Integer getSeq() {
		if (this.seq == null) {
			return 9999;
		}
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Integer getSort1() {
		if (this.sort1 == null) {
			return 99999;
		}
        return sort1;
    }

    public void setSort1(Integer sort1) {
        this.sort1 = sort1;
    }

    public Integer getSort2() {
    	if (this.sort2 == null) {
			return 99999;
		}
        return sort2;
    }

    public void setSort2(Integer sort2) {
        this.sort2 = sort2;
    }

    public Integer getExpressType() {
    	if (this.expressType == null) {
			return 3;
		}
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public Long getCategoryId() {
    	if (this.categoryId == null) {
			return 0L;
		}
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryCode() {
        return StringUtils.trimToEmpty(categoryCode);
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public List<Map> getFrontCategories() {
        return frontCategories;
    }

    public void setFrontCategories(List<Map> frontCategories) {
    	if (frontCategories == null) {return;}
        this.frontCategories = frontCategories;
    }

    public List<Map> getStocks() {
        return stocks;
    }

    public void setStocks(List<Map> stocks) {
        this.stocks = stocks;
    }
	
	public List<String> getSmallIconList() {
		return smallIconList;
	}

	public void setSmallIconList(List<String> smallIconList) {
		if (smallIconList == null) {return;}
		this.smallIconList = smallIconList;
	}

	public List<String> getLargeIconList() {
		return largeIconList;
	}

	public void setLargeIconList(List<String> largeIconList) {
		if (largeIconList == null) {return;}
		this.largeIconList = largeIconList;
	}

	public List<PsTagVO> getPsTags() {
		return psTags;
	}

	public void setPsTags(List<PsTagVO> psTags) {
		if (psTags == null) {return;}
		this.psTags = psTags;
	}

	public List<PsDeliveryVO> getSelfDeliveries() {
        return selfDeliveries;
    }

    public void setSelfDeliveries(List<PsDeliveryVO> selfDeliveries) {
    	if (selfDeliveries == null) {return;}
        this.selfDeliveries = selfDeliveries;
    }

    public List<PsChnProdSaleSku> getChnCanSaleSKu() {
        return chnCanSaleSKu;
    }

    public void setChnCanSaleSKu(List<PsChnProdSaleSku> chnCanSaleSKu) {
    	if (chnCanSaleSKu == null) {return;}
        this.chnCanSaleSKu = chnCanSaleSKu;
    }

    public List<String> getChnSaleChnCodes() {
        return chnSaleChnCodes;
    }

    public void setChnSaleChnCodes(List<String> chnSaleChnCodes) {
    	if (chnSaleChnCodes == null) {return;}
        this.chnSaleChnCodes = chnSaleChnCodes;
    }

    public List<String> getOnShelfChnCodes() {
        return onShelfChnCodes;
    }

    public void setOnShelfChnCodes(List<String> onShelfChnCodes) {
    	if (onShelfChnCodes == null) {return;}
        this.onShelfChnCodes = onShelfChnCodes;
    }

    public List<String> getOffShelfChnCodes() {
        return offShelfChnCodes;
    }

    public void setOffShelfChnCodes(List<String> offShelfChnCodes) {
    	if (offShelfChnCodes == null) {return;}
        this.offShelfChnCodes = offShelfChnCodes;
    }

    public List<PsDynmContentVO> getDynmContents() {
        return dynmContents;
    }

    public void setDynmContents(List<PsDynmContentVO> dynmContents) {
    	if (dynmContents == null) {return;}
        this.dynmContents = dynmContents;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return listPrice;
    }

    public void setListPrice(BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public Integer getAllowVipDiscount() {
        return allowVipDiscount;
    }

    public void setAllowVipDiscount(Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return allowNoteCard;
    }

    public void setAllowNoteCard(Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }

    public Integer getPrepareDays() {
        return prepareDays;
    }

    public void setPrepareDays(Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return selectDeliveryDays;
    }

    public void setSelectDeliveryDays(Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

    public String getPicList() {
        return picList == null?"":picList;
    }

    public void setPicList(String picList) {
        this.picList = picList;
    }

    public String getPicDetail() {
        return picDetail == null?"":picDetail;
    }

    public void setPicDetail(String picDetail) {
        this.picDetail = picDetail;
    }

    public String getPicThumb() {
        return picThumb == null?"":picThumb;
    }

    public void setPicThumb(String picThumb) {
        this.picThumb = picThumb;
    }

    public String getName() {
        return StringUtils.trimToEmpty(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn == null?"":nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
    	if (skuCodes == null) {return;}
        this.skuCodes = skuCodes;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSkuCategoryDesc() {
        return skuCategoryDesc;
    }

    public void setSkuCategoryDesc(String skuCategoryDesc) {
        this.skuCategoryDesc = skuCategoryDesc;
    }

    public List<PsChnProdSaleSku> getChnCanSeeSKu() {
        return chnCanSeeSKu;
    }

    public void setChnCanSeeSKu(List<PsChnProdSaleSku> chnCanSeeSKu) {
    	if (chnCanSeeSKu == null) {
			return;
		}
        this.chnCanSeeSKu = chnCanSeeSKu;
    }

    public Date getSaleStartDate() {
        return saleStartDate;
    }

    public void setSaleStartDate(Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public String getPicDetailMul() {
        return StringUtils.trimToEmpty(picDetailMul);
    }

    public void setPicDetailMul(String picDetailMul) {
        this.picDetailMul = picDetailMul;
    }
    
    public String getDescription() {
		return StringUtils.trimToEmpty(description);
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
    public List<Map> getBrandList() {
		return brandList;
	}
	public void setBrandList(List<Map> brandList) {
		this.brandList = brandList;
	}
	public List<PsChnProdTimeCodeInfo> getChannelProdInfo() {
		return channelProdInfo;
	}

	public void setChannelProdInfo(List<PsChnProdTimeCodeInfo> channelProdInfo) {
		this.channelProdInfo = channelProdInfo;
	}
	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}
    public List<Map> getLabels() {
		return labels;
	}
	public void setLabels(List<Map> labels) {
		this.labels = labels;
	}
}
