/*
 * Decompiled with CFR 0.152.
 */
package com.litesalt.batch.queue;

import com.alibaba.fastjson.JSONObject;
import com.litesalt.batch.context.QueueContext;
import com.litesalt.batch.queue.RowBatchQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisRowBatchQueue<T>
extends RowBatchQueue<T> {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 6379;
    private final Logger logger = LoggerFactory.getLogger(RedisRowBatchQueue.class);
    private JedisPool jedisPool;
    private String key;

    private void buildKey() {
        Class clazz = this.context.getClazz();
        StringBuilder stringBuilder = new StringBuilder("ROW_BATCH_QUEUE_").append(clazz.getSimpleName().toUpperCase());
        if (this.context != null) {
            if (this.context.getType() != null) {
                stringBuilder.append("_").append(this.context.getType().toString().toUpperCase());
            }
            if (StringUtils.isNotBlank((CharSequence)this.context.getRedisKeyExt())) {
                stringBuilder.append("_").append(this.context.getRedisKeyExt().toUpperCase());
            }
        }
        this.key = stringBuilder.toString();
    }

    public RedisRowBatchQueue() {
        this(DEFAULT_HOST, 6379, null);
    }

    public RedisRowBatchQueue(String host, int port, String auth) {
        this(new QueueContext(), host, port, auth);
    }

    public RedisRowBatchQueue(QueueContext<T> context, String host, int port, String auth) {
        super(context);
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(100);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, 3000, auth);
        this.buildKey();
    }

    @Override
    public void put(T t) {
        this.put(Arrays.asList(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(List<T> ts) {
        if (ts != null && ts.size() > 0) {
            try (Jedis jedis = this.jedisPool.getResource();){
                Pipeline pipe = jedis.pipelined();
                for (T t : ts) {
                    String value = JSONObject.toJSONString(t);
                    pipe.rpush(this.key, new String[]{value});
                }
                pipe.sync();
            }
        }
    }

    @Override
    public T take() {
        List<T> take = this.take(1L);
        if (take != null && take.size() > 0) {
            return take.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> take(long len) {
        ArrayList<Object> rt = new ArrayList<Object>();
        try (Jedis jedis = null;){
            if (len > 0L) {
                jedis = this.jedisPool.getResource();
                Pipeline pipe = jedis.pipelined();
                ArrayList<Response> responseList = new ArrayList<Response>();
                while (len > 0L) {
                    responseList.add(pipe.lpop(this.key));
                    --len;
                }
                pipe.sync();
                String item = null;
                for (Response response : responseList) {
                    item = (String)response.get();
                    if (!StringUtils.isNotBlank((CharSequence)item)) continue;
                    rt.add(JSONObject.parseObject((String)item, this.context.getClazz()));
                }
            }
        }
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> takeAll() {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            Long len = jedis.llen(this.key);
            List<T> list = this.take(len != null ? len : 0L);
            return list;
        }
    }
}

