/*
 * Decompiled with CFR 0.152.
 */
package com.litesalt.batch.queue;

import com.litesalt.batch.context.QueueContext;
import com.litesalt.batch.queue.RowBatchQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MemoryRowBatchQueue<T>
extends RowBatchQueue<T> {
    private Queue<T> items = new ConcurrentLinkedQueue<T>();

    public MemoryRowBatchQueue() {
        this(new QueueContext());
    }

    public MemoryRowBatchQueue(QueueContext<T> context) {
        super(context);
    }

    @Override
    public void put(T t) {
        this.items.add(t);
    }

    @Override
    public void put(List<T> ts) {
        if (ts != null && ts.size() > 0) {
            for (T t : ts) {
                this.put(t);
            }
        }
    }

    @Override
    public T take() {
        return this.items.poll();
    }

    @Override
    public List<T> take(long len) {
        ArrayList<T> rt = new ArrayList<T>();
        while (len > 0L) {
            T item = this.take();
            if (item != null) {
                rt.add(item);
            }
            --len;
        }
        return rt;
    }

    @Override
    public List<T> takeAll() {
        return this.take(this.items.size());
    }
}

