/*
 * Decompiled with CFR 0.152.
 */
package com.litesalt.batch.handler;

import com.litesalt.batch.context.HandlerContext;
import com.litesalt.batch.monitor.QueueStatusMonitor;
import com.litesalt.batch.queue.RowBatchQueue;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public abstract class RowBatchHandler<T>
extends Observable {
    protected final Logger logger = Logger.getLogger(RowBatchHandler.class);
    protected AtomicLong loopSize = new AtomicLong(0L);
    protected HandlerContext<T> context;
    private ExecutorService threadPool = Executors.newFixedThreadPool(10);

    public RowBatchHandler(HandlerContext<T> context) {
        this.addObserver(new QueueStatusMonitor(this));
        this.context = context;
    }

    public abstract void rowBatch(List<T> var1);

    public void insertWithBatch(List<T> items) {
        try {
            RowBatchQueue<T> queue = this.context.getQueue();
            if (queue != null && items != null && items.size() > 0) {
                queue.put(items);
                if (!this.context.isSyn()) {
                    this.loopSize.addAndGet(items.size());
                    final long submitCapacity = this.context.getSubmitCapacity();
                    if (this.loopSize.get() >= submitCapacity) {
                        this.threadPool.submit(new Thread(){

                            @Override
                            public void run() {
                                try {
                                    RowBatchHandler.this.rowBatch(RowBatchHandler.this.take(submitCapacity));
                                }
                                catch (Exception e) {
                                    RowBatchHandler.this.logger.error((Object)"\u6279\u6b21\u63d2\u5165\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                                }
                            }
                        });
                        this.loopSize.set(0L);
                        this.setChanged();
                        this.notifyObservers();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        this.rowBatch(this.takeAll());
    }

    public List<T> take(long len) {
        try {
            RowBatchQueue<T> queue = this.context.getQueue();
            if (queue != null) {
                return queue.take(len);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)"take is interrupted", (Throwable)e);
            return null;
        }
    }

    public List<T> takeAll() {
        try {
            RowBatchQueue<T> queue = this.context.getQueue();
            if (queue != null) {
                return queue.takeAll();
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)"take is interrupted", (Throwable)e);
            return null;
        }
    }
}

