/*
 * Decompiled with CFR 0.152.
 */
package com.litesalt.batch.handler;

import com.litesalt.batch.context.HandlerContext;
import com.litesalt.batch.enums.FileSavedCapacity;
import com.litesalt.batch.handler.RowBatchHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

public class FileRowBatchHandler<T>
extends RowBatchHandler<T> {
    private File file;
    private String originFilePath;
    private Calendar fileDate = Calendar.getInstance();
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private FileSavedCapacity capacity = FileSavedCapacity.SINGLE;

    private File getFile() {
        Calendar now;
        if (this.capacity.equals((Object)FileSavedCapacity.DAILY) && ((now = Calendar.getInstance()).get(1) > this.fileDate.get(1) || now.get(2) > this.fileDate.get(2) || now.get(5) > this.fileDate.get(5))) {
            this.fileDate = now;
            this.file = new File(this.originFilePath + "-" + this.simpleDateFormat.format(this.fileDate.getTime()));
        }
        return this.file;
    }

    public FileRowBatchHandler(HandlerContext<T> context, File file, FileSavedCapacity capacity) {
        super(context);
        this.originFilePath = file.getAbsolutePath();
        this.file = capacity.equals((Object)FileSavedCapacity.DAILY) ? new File(this.originFilePath + "-" + this.simpleDateFormat.format(this.fileDate.getTime())) : file;
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rowBatch(List<T> batchList) {
        this.logger.info((Object)"\u5f00\u59cb\u6279\u6b21\u63d2\u5165\u6587\u4ef6");
        if (batchList != null && batchList.size() > 0) {
            FileOutputStream os = null;
            PrintWriter pw = null;
            try {
                os = new FileOutputStream(this.getFile(), true);
                pw = new PrintWriter(os, true);
                for (T t : batchList) {
                    if (t == null) continue;
                    pw.println(t);
                }
                pw.flush();
            }
            catch (Exception e) {
                this.logger.error((Object)"\u6279\u6b21\u63d2\u5165\u6587\u4ef6\u5f02\u5e38: ", (Throwable)e);
            }
            finally {
                try {
                    pw.close();
                }
                catch (Exception e2) {
                    this.logger.error((Object)"\u6279\u6b21\u63d2\u5165\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e2);
                }
            }
        }
    }
}

