/*
 * Decompiled with CFR 0.152.
 */
package com.litesalt.batch.handler;

import com.litesalt.batch.annotation.AliasField;
import com.litesalt.batch.annotation.AliasTable;
import com.litesalt.batch.annotation.ExcludeField;
import com.litesalt.batch.context.HandlerContext;
import com.litesalt.batch.entity.DBColumnMetaData;
import com.litesalt.batch.handler.RowBatchHandler;
import com.litesalt.batch.util.CamelCaseUtils;
import com.litesalt.batch.util.Reflections;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBRowBatchHandler<T>
extends RowBatchHandler<T> {
    private JdbcTemplate jdbcTemplate;
    private String insertSql;
    private Field[] fields;
    private Map<String, DBColumnMetaData> metaMap = new HashMap<String, DBColumnMetaData>();

    private void prepareSql() {
        StringBuffer sql = new StringBuffer();
        Class clazz = this.context.getClazz();
        sql.append(" insert into ").append(this.getAliasTable(clazz));
        sql.append("(");
        int m = 0;
        for (Field field : clazz.getDeclaredFields()) {
            ExcludeField excludeField = field.getAnnotation(ExcludeField.class);
            if (excludeField != null) continue;
            ++m;
            sql.append(this.getAliasField(field));
            sql.append(",");
        }
        sql = sql.replace(sql.length() - 1, sql.length(), "");
        sql.append(") values(");
        for (int n = 0; n < m; ++n) {
            sql.append("?");
            if (n >= m - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        this.insertSql = sql.toString();
    }

    private boolean initDBMetaData() {
        boolean flag = false;
        try {
            Class clazz = this.context.getClazz();
            DatabaseMetaData metaData = this.jdbcTemplate.getDataSource().getConnection().getMetaData();
            ResultSet rs = metaData.getColumns(null, "%", this.getAliasTable(clazz), "%");
            while (rs.next()) {
                this.metaMap.put(rs.getString("COLUMN_NAME"), new DBColumnMetaData(rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"), rs.getObject("COLUMN_DEF")));
            }
            flag = true;
        }
        catch (Exception e) {
            this.logger.error((Object)"init db metadata wrong", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    private String getAliasTable(Class<T> clazz) {
        AliasTable aliasTable = clazz.getAnnotation(AliasTable.class);
        if (aliasTable != null && StringUtils.isNotBlank((CharSequence)aliasTable.value())) {
            return aliasTable.value();
        }
        return CamelCaseUtils.toUnderScoreCase(clazz.getSimpleName());
    }

    private String getAliasField(Field field) {
        AliasField aliasField = field.getAnnotation(AliasField.class);
        if (aliasField != null && StringUtils.isNotBlank((CharSequence)aliasField.value())) {
            return aliasField.value();
        }
        return CamelCaseUtils.toUnderScoreCase(field.getName());
    }

    public DBRowBatchHandler(HandlerContext<T> context, JdbcTemplate jdbcTemplate) {
        super(context);
        this.jdbcTemplate = jdbcTemplate;
        if (this.initDBMetaData()) {
            Class<T> clazz = context.getClazz();
            this.fields = clazz.getDeclaredFields();
            this.prepareSql();
        }
    }

    @Override
    public void rowBatch(final List<T> batchList) {
        long startTimeMillis = System.currentTimeMillis();
        this.logger.info((Object)"\u5f00\u59cb\u6279\u6b21\u63d2\u5165\u6570\u636e\u5e93");
        if (batchList != null && batchList.size() > 0) {
            this.jdbcTemplate.batchUpdate(this.insertSql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    Object t = batchList.get(i);
                    Object o = null;
                    DBColumnMetaData metaData = null;
                    int n = 0;
                    block10: for (Field field : DBRowBatchHandler.this.fields) {
                        ExcludeField excludeField = field.getAnnotation(ExcludeField.class);
                        if (excludeField != null) continue;
                        ++n;
                        o = Reflections.invokeGetter(t, field.getName());
                        metaData = (DBColumnMetaData)DBRowBatchHandler.this.metaMap.get(DBRowBatchHandler.this.getAliasField(field));
                        if (o == null) {
                            if (metaData.getColumnDef() == null) {
                                ps.setNull(n, 0);
                                continue;
                            }
                            o = metaData.getColumnDef();
                        }
                        switch (metaData.getDataType()) {
                            case -9: 
                            case 1: 
                            case 12: {
                                ps.setString(n, (String)o);
                                continue block10;
                            }
                            case -4: 
                            case 2004: {
                                ps.setBytes(n, (byte[])o);
                                continue block10;
                            }
                            case -6: 
                            case 5: {
                                ps.setShort(n, Short.parseShort(o.toString()));
                                continue block10;
                            }
                            case 4: {
                                ps.setInt(n, Integer.parseInt(o.toString()));
                                continue block10;
                            }
                            case -5: {
                                ps.setLong(n, Long.parseLong(o.toString()));
                                continue block10;
                            }
                            case 91: {
                                ps.setDate(n, new Date(((java.util.Date)o).getTime()));
                                continue block10;
                            }
                            case 93: {
                                ps.setTimestamp(n, new Timestamp(((java.util.Date)o).getTime()));
                                continue block10;
                            }
                            case 3: {
                                ps.setBigDecimal(n, (BigDecimal)o);
                            }
                        }
                    }
                }

                public int getBatchSize() {
                    return batchList != null ? batchList.size() : 0;
                }
            });
            this.logger.info((Object)("this batch spend " + (System.currentTimeMillis() - startTimeMillis) + " millisecond"));
        }
    }
}

