/*
 * Decompiled with CFR 0.152.
 */
package com.litesalt.batch;

import com.litesalt.batch.context.HandlerContext;
import com.litesalt.batch.context.QueueContext;
import com.litesalt.batch.enums.FileSavedCapacity;
import com.litesalt.batch.enums.TargetType;
import com.litesalt.batch.handler.FileRowBatchHandler;
import com.litesalt.batch.listener.RowBatchListener;
import com.litesalt.batch.queue.MemoryRowBatchQueue;
import com.litesalt.batch.queue.RedisRowBatchQueue;
import java.io.File;

public class FileRowBatchListenerBuilder {
    public static <T> RowBatchListener<T> buildMemoryRowBatchListener(File file, long submitCapacity, Class<T> clazz, FileSavedCapacity capacity) {
        return FileRowBatchListenerBuilder.buildMemoryRowBatchListener(file, submitCapacity, clazz, capacity, false);
    }

    public static <T> RowBatchListener<T> buildMemoryRowBatchListener(File file, long submitCapacity, Class<T> clazz, FileSavedCapacity capacity, boolean syn) {
        QueueContext qContext = new QueueContext(TargetType.FILE);
        MemoryRowBatchQueue queue = new MemoryRowBatchQueue(qContext);
        HandlerContext hContext = new HandlerContext(queue, submitCapacity, clazz, syn);
        FileRowBatchHandler rowBatchHandler = new FileRowBatchHandler(hContext, file, capacity);
        RowBatchListener listener = new RowBatchListener(rowBatchHandler);
        return listener;
    }

    public static <T> RowBatchListener<T> buildRedisRowBatchListener(File file, long submitCapacity, Class<T> clazz, FileSavedCapacity capacity, String host, int port, String auth) {
        return FileRowBatchListenerBuilder.buildRedisRowBatchListener(file, submitCapacity, clazz, capacity, host, port, auth, false);
    }

    public static <T> RowBatchListener<T> buildRedisRowBatchListener(File file, long submitCapacity, Class<T> clazz, FileSavedCapacity capacity, String host, int port, String auth, boolean syn) {
        QueueContext<T> qContext = new QueueContext<T>(TargetType.FILE, clazz, file.getName());
        RedisRowBatchQueue<T> queue = new RedisRowBatchQueue<T>(qContext, host, port, auth);
        HandlerContext<T> hContext = new HandlerContext<T>(queue, submitCapacity, clazz, syn);
        FileRowBatchHandler<T> rowBatchHandler = new FileRowBatchHandler<T>(hContext, file, capacity);
        RowBatchListener<T> listener = new RowBatchListener<T>(rowBatchHandler);
        return listener;
    }
}

