/*
 * Decompiled with CFR 0.152.
 */
package com.litesalt.batch;

import com.litesalt.batch.context.HandlerContext;
import com.litesalt.batch.context.QueueContext;
import com.litesalt.batch.enums.TargetType;
import com.litesalt.batch.handler.DBRowBatchHandler;
import com.litesalt.batch.listener.RowBatchListener;
import com.litesalt.batch.queue.MemoryRowBatchQueue;
import com.litesalt.batch.queue.RedisRowBatchQueue;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBRowBatchListenerBuilder {
    public static <T> RowBatchListener<T> buildMemoryRowBatchListener(JdbcTemplate jdbcTemplate, long submitCapacity, Class<T> clazz) {
        return DBRowBatchListenerBuilder.buildMemoryRowBatchListener(jdbcTemplate, submitCapacity, clazz, false);
    }

    public static <T> RowBatchListener<T> buildMemoryRowBatchListener(JdbcTemplate jdbcTemplate, long submitCapacity, Class<T> clazz, boolean syn) {
        MemoryRowBatchQueue queue = new MemoryRowBatchQueue();
        HandlerContext context = new HandlerContext(queue, submitCapacity, clazz, syn);
        DBRowBatchHandler rowBatchHandler = new DBRowBatchHandler(context, jdbcTemplate);
        RowBatchListener listener = new RowBatchListener(rowBatchHandler);
        return listener;
    }

    public static <T> RowBatchListener<T> buildRedisRowBatchListener(JdbcTemplate jdbcTemplate, long submitCapacity, Class<T> clazz, String host, int port, String auth) {
        return DBRowBatchListenerBuilder.buildRedisRowBatchListener(jdbcTemplate, submitCapacity, clazz, host, port, auth, false);
    }

    public static <T> RowBatchListener<T> buildRedisRowBatchListener(JdbcTemplate jdbcTemplate, long submitCapacity, Class<T> clazz, String host, int port, String auth, boolean syn) {
        QueueContext<T> qContext = new QueueContext<T>(TargetType.DB, clazz);
        RedisRowBatchQueue<T> queue = new RedisRowBatchQueue<T>(qContext, host, port, auth);
        HandlerContext<T> context = new HandlerContext<T>(queue, submitCapacity, clazz, syn);
        DBRowBatchHandler<T> rowBatchHandler = new DBRowBatchHandler<T>(context, jdbcTemplate);
        RowBatchListener<T> listener = new RowBatchListener<T>(rowBatchHandler);
        return listener;
    }
}

