/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.exception;

public class DoudianOpException
extends RuntimeException {
    private Code code;

    public Code getCode() {
        return this.code;
    }

    public DoudianOpException(Code code) {
        super(code.message);
        this.code = code;
    }

    public DoudianOpException(Code code, String info) {
        super(String.format("code.message: %s, info: %s", code.message, info));
        this.code = code;
    }

    public DoudianOpException(Exception e) {
        super(e);
        this.code = Code.UNRECOGNIZED_EXCEPTION;
    }

    public DoudianOpException(Code code, Exception e) {
        super(e);
        this.code = code;
    }

    public static enum Code {
        UNRECOGNIZED_EXCEPTION(-999, "\u672a\u9884\u77e5\u5f02\u5e38"),
        HTTP_RESPONSE_STATUS_CODE_NOT_2XX(10001, "HTTP\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u7801\u975e200"),
        INIT_REQUEST_PARAM_ERROR(10002, "\u521d\u59cb\u5316Request\u5931\u8d25"),
        CALC_MD5_ERROR(10003, "\u8ba1\u7b97md5\u5931\u8d25"),
        URL_ENCODE_ERROR(10004, "\u5bf9url\u8fdb\u884cencode\u5931\u8d25"),
        HTTP_REQUEST_ERROR(10005, "\u53d1\u9001http\u8bf7\u6c42\u5931\u8d25"),
        JSON_ERROR(10006, "json\u5e8f\u5217\u5316\uff08\u53cd\u5e8f\u5217\u5316\uff09\u5931\u8d25"),
        CALC_HMAC_ERROR(10007, "\u8ba1\u7b97hmac\u5931\u8d25"),
        REFLECT_METHOD_NOT_EXIST(10008, "\u53cd\u5c04\u8c03\u7528-\u65b9\u6cd5\u4e0d\u5b58\u5728"),
        UNSUPPORTED_HTTP_METHOD(10009, "\u4e0d\u652f\u6301\u7684http\u65b9\u6cd5"),
        APP_SECRET_NOT_FOUND(10010, "\u672a\u627e\u5230appKey\u5bf9\u5e94\u7684appSecret\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5728AddAppKeyAndAppSecret\u65b9\u6cd5\u4e2d\u6dfb\u52a0appKey\u548cappSecret\u5bf9"),
        PARAMETER_REQUIRED_CHECK_ERROR(20001, "\u5fc5\u586b\u53c2\u6570\u6821\u9a8c\u5931\u8d25"),
        MSG_CHECK_SIGN_ERROR(20002, "\u6d88\u606f\u7f51\u5173\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38"),
        PARAMETER_CHECK_ERROR(20003, "\u53c2\u6570\u6821\u9a8c\u5931\u8d25"),
        MATERIAL_GATEWAY_RESP_EMPTY_ERROR(30001, "\u8fd4\u56debody\u4e3a\u7a7a"),
        MATERIAL_GATEWAY_ERROR(30002, "\u83b7\u53d6\u4e0a\u4f20\u5730\u5740\u9519\u8bef");

        int code;
        String message;

        private Code(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}

