/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core;

import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.api.token.AccessTokenParam;
import com.doudian.open.api.token.AccessTokenRequest;
import com.doudian.open.api.token.AccessTokenResponse;
import com.doudian.open.api.token.RefreshTokenParam;
import com.doudian.open.api.token.RefreshTokenRequest;
import com.doudian.open.api.token.RefreshTokenResponse;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpClient;
import com.doudian.open.core.DoudianOpClientHolder;
import com.doudian.open.core.DoudianOpConfig;
import com.doudian.open.core.GlobalConfig;
import java.net.URLEncoder;

public class AccessTokenBuilder {
    public static AccessToken build(Long shopId) {
        return AccessTokenBuilder.build((DoudianOpConfig)GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), shopId);
    }

    public static AccessToken build(String authId, String authSubjectType) {
        return AccessTokenBuilder.buildSelfUseGeneric(GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), authId, authSubjectType, null);
    }

    public static AccessToken build(String code) {
        return AccessTokenBuilder.build((DoudianOpConfig)GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), code);
    }

    public static AccessToken buildWithAppKey(Long shopId, String appKey) {
        return AccessTokenBuilder.build(GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), null, shopId, true, appKey);
    }

    public static AccessToken buildWithAppKey(String authId, String authSubjectType, String appKey) {
        return AccessTokenBuilder.buildSelfUseGeneric(GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), authId, authSubjectType, appKey);
    }

    public static AccessToken buildWithAppKey(String code, String appKey) {
        return AccessTokenBuilder.build(GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), code, null, false, appKey);
    }

    public static AccessToken build(DoudianOpConfig config, DoudianOpClient httpClient, Long shopId) {
        return AccessTokenBuilder.build(config, httpClient, null, shopId, true, null);
    }

    public static AccessToken build(DoudianOpConfig config, DoudianOpClient httpClient, String code) {
        return AccessTokenBuilder.build(config, httpClient, code, null, false, null);
    }

    public static AccessToken parse(String accessTokenStr) {
        return AccessTokenBuilder.parse(accessTokenStr, null);
    }

    public static AccessToken parse(String accessTokenStr, String appKey) {
        AccessTokenResponse response = new AccessTokenResponse();
        response.setCode("10000");
        AccessTokenData data = new AccessTokenData();
        data.setAccessToken(accessTokenStr);
        response.setData(data);
        return AccessToken.wrapWithAppKey(response, appKey);
    }

    public static AccessToken refresh(AccessToken accessToken) {
        return AccessTokenBuilder.refresh(GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), accessToken, accessToken.getAppKey());
    }

    public static AccessToken refresh(String refreshTokenStr) {
        AccessToken accessToken = AccessToken.wrap(null, refreshTokenStr);
        return AccessTokenBuilder.refresh(GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), accessToken, null);
    }

    public static AccessToken refreshWithAppKey(AccessToken accessToken, String appKey) {
        return AccessTokenBuilder.refresh(GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), accessToken, appKey);
    }

    public static AccessToken refreshWithAppKey(String refreshTokenStr, String appKey) {
        AccessToken accessToken = AccessToken.wrapWithAppKey(null, refreshTokenStr, appKey);
        return AccessTokenBuilder.refresh(GlobalConfig.getGlobalConfig(), DoudianOpClientHolder.getClient(), accessToken, appKey);
    }

    public static AccessToken refresh(DoudianOpConfig config, DoudianOpClient client, AccessToken accessToken, String appKey) {
        RefreshTokenRequest request = new RefreshTokenRequest();
        request.setConfig(config);
        request.setClient(client);
        ((RefreshTokenParam)request.getParam()).setGrantType("refresh_token");
        ((RefreshTokenParam)request.getParam()).setRefreshToken(accessToken.getRefreshToken());
        AccessToken ac = null;
        if (appKey != null) {
            ac = new AccessToken();
            ac.setAppKey(appKey);
        }
        RefreshTokenResponse response = (RefreshTokenResponse)request.execute(ac);
        return AccessToken.wrapWithAppKey(response, appKey);
    }

    private static AccessToken build(DoudianOpConfig config, DoudianOpClient client, String code, Long shopId, boolean isSelfAuth, String appKey) {
        AccessTokenRequest request = new AccessTokenRequest();
        if (isSelfAuth) {
            ((AccessTokenParam)request.getParam()).setCode("");
            ((AccessTokenParam)request.getParam()).setGrantType("authorization_self");
            ((AccessTokenParam)request.getParam()).setShopId(shopId);
        } else {
            ((AccessTokenParam)request.getParam()).setCode(code);
            ((AccessTokenParam)request.getParam()).setGrantType("authorization_code");
        }
        request.setConfig(config);
        request.setClient(client);
        AccessToken ac = null;
        if (appKey != null) {
            ac = new AccessToken();
            ac.setAppKey(appKey);
        }
        AccessTokenResponse resp = (AccessTokenResponse)request.execute(ac);
        return AccessToken.wrapWithAppKey(resp, appKey);
    }

    private static AccessToken buildSelfUseGeneric(DoudianOpConfig config, DoudianOpClient client, String authId, String authSubjectType, String appKey) {
        AccessTokenRequest request = new AccessTokenRequest();
        ((AccessTokenParam)request.getParam()).setCode("");
        ((AccessTokenParam)request.getParam()).setGrantType("authorization_self");
        ((AccessTokenParam)request.getParam()).setAuthId(authId);
        ((AccessTokenParam)request.getParam()).setAuthSubjectType(authSubjectType);
        request.setConfig(config);
        request.setClient(client);
        AccessToken ac = null;
        if (appKey != null) {
            ac = new AccessToken();
            ac.setAppKey(appKey);
        }
        AccessTokenResponse resp = (AccessTokenResponse)request.execute(ac);
        return AccessToken.wrapWithAppKey(resp, appKey);
    }

    private static String getEncodeString(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception exception) {
            return str;
        }
    }
}

