/*
 * Decompiled with CFR 0.152.
 */
package com.jd.platform.hotkey.common.rule;

public class KeyRule {
    private String key;
    private boolean prefix;
    private int interval;
    private int threshold;
    private int duration;
    private String desc;

    public KeyRule(String key, boolean prefix, int interval, int threshold, int duration) {
        this(key, prefix, interval, threshold, duration, null);
    }

    public KeyRule(String key, boolean prefix, int interval, int threshold, int duration, String desc) {
        this.key = key;
        this.prefix = prefix;
        this.interval = interval;
        this.threshold = threshold;
        this.duration = duration;
        this.desc = desc;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getDuration() {
        return this.duration;
    }

    public String toString() {
        return "DefaultKeyRule{key='" + this.key + '\'' + ", prefix=" + this.prefix + ", interval=" + this.interval + ", threshold=" + this.threshold + ", duration=" + this.duration + '}';
    }

    public static class Builder {
        private String key;
        private boolean prefix;
        private int interval;
        private int threshold;
        private int duration;
        private String desc;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder prefix(boolean prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder interval(int interval) {
            if (interval < 1) {
                interval = 1;
            }
            this.interval = interval;
            return this;
        }

        public Builder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder duration(int duration) {
            if (duration < 1) {
                duration = 1;
            }
            this.duration = duration;
            return this;
        }

        public KeyRule build() {
            return new KeyRule(this.key, this.prefix, this.interval, this.threshold, this.duration, this.desc);
        }
    }
}

