/*
 * Decompiled with CFR 0.152.
 */
package com.fpx.api.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fpx.api.constants.AmbientEnum;
import com.fpx.api.model.TokenResultEntity;
import com.fpx.api.utils.HttpClientUtils;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class TokenUtil
extends HttpClientUtils {
    private static final String ACCESS_TOKEN_RUL = "/accessToken/get";

    public static TokenResultEntity getToken(String clientId, String redirectUri, String clientSecret, String code, String grantType, AmbientEnum ambient) {
        String urlProfiles = TokenUtil.getAddress(ambient);
        String url = String.format(urlProfiles + "%s", ACCESS_TOKEN_RUL);
        String result = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("client_id", clientId);
        map.put("redirect_uri", redirectUri);
        map.put("client_secret", clientSecret);
        map.put("grant_type", grantType);
        map.put("code", code);
        try {
            result = TokenUtil.post(url, map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return TokenUtil.pareJson(result);
    }

    public static TokenResultEntity getTokenByRefreshToken(String clientId, String clientSecret, String grantType, String refreshToken, String redirectUri, AmbientEnum ambient) {
        String urlProfiels = TokenUtil.getAddress(ambient);
        String url = String.format(urlProfiels + "%s", ACCESS_TOKEN_RUL);
        String result = null;
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("client_id", clientId);
        requestMap.put("client_secret", clientSecret);
        requestMap.put("grant_type", grantType);
        requestMap.put("refresh_token", refreshToken);
        requestMap.put("redirect_uri", redirectUri);
        try {
            result = TokenUtil.post(url, requestMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return TokenUtil.pareJson(result);
    }

    private static TokenResultEntity pareJson(String jsonStr) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        String accessToken = jsonObject.getString("access_token");
        String refreshToke = jsonObject.getString("refresh_token");
        String expiresIn = jsonObject.getString("expires_in");
        return new TokenResultEntity(accessToken, refreshToke, expiresIn);
    }
}

